"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SYSTEM_INDICES_MIGRATION_POLL_INTERVAL_MS = exports.RECENT_DURATION_MS = exports.MIN_VERSION_TO_UPGRADE_TO_LATEST = exports.LATEST_VERSION = exports.DEPRECATION_WARNING_UPPER_LIMIT = exports.DEPRECATION_LOGS_SOURCE_ID = exports.DEPRECATION_LOGS_ORIGIN_FIELD = exports.DEPRECATION_LOGS_INDEX_PATTERN = exports.DEPRECATION_LOGS_INDEX = exports.DEPRECATION_LOGS_COUNT_POLL_INTERVAL_MS = exports.CLUSTER_UPGRADE_STATUS_POLL_INTERVAL_MS = exports.CLOUD_SNAPSHOT_REPOSITORY = exports.CLOUD_BACKUP_STATUS_POLL_INTERVAL_MS = exports.APP_LOGS_COUNT_INDEX_PRIVILEGES = exports.APP_LOGS_COUNT_CLUSTER_PRIVILEGES = exports.APPS_WITH_DEPRECATION_LOGS = exports.API_BASE_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_BASE_PATH = exports.API_BASE_PATH = '/api/upgrade_assistant';

/**
 * This is the repository where Cloud stores its backup snapshots.
 */
const CLOUD_SNAPSHOT_REPOSITORY = exports.CLOUD_SNAPSHOT_REPOSITORY = 'found-snapshots';
const DEPRECATION_WARNING_UPPER_LIMIT = exports.DEPRECATION_WARNING_UPPER_LIMIT = 999999;
const DEPRECATION_LOGS_SOURCE_ID = exports.DEPRECATION_LOGS_SOURCE_ID = 'deprecation_logs';
const DEPRECATION_LOGS_INDEX = exports.DEPRECATION_LOGS_INDEX = '.logs-deprecation.elasticsearch-default';
const DEPRECATION_LOGS_INDEX_PATTERN = exports.DEPRECATION_LOGS_INDEX_PATTERN = '.logs-deprecation.elasticsearch-default';
const CLUSTER_UPGRADE_STATUS_POLL_INTERVAL_MS = exports.CLUSTER_UPGRADE_STATUS_POLL_INTERVAL_MS = 45000;
const CLOUD_BACKUP_STATUS_POLL_INTERVAL_MS = exports.CLOUD_BACKUP_STATUS_POLL_INTERVAL_MS = 60000;
const DEPRECATION_LOGS_COUNT_POLL_INTERVAL_MS = exports.DEPRECATION_LOGS_COUNT_POLL_INTERVAL_MS = 15000;
const SYSTEM_INDICES_MIGRATION_POLL_INTERVAL_MS = exports.SYSTEM_INDICES_MIGRATION_POLL_INTERVAL_MS = 15000;

/**
 * List of Elastic apps that potentially can generate deprecation logs.
 * We want to filter those out for our users so they only see deprecation logs
 * that _they_ are generating.
 */
const APPS_WITH_DEPRECATION_LOGS = exports.APPS_WITH_DEPRECATION_LOGS = ['kibana', 'cloud', 'logstash', 'beats', 'fleet', 'ml', 'security', 'observability', 'enterprise-search'];

// The field that will indicate which elastic product generated the deprecation log
const DEPRECATION_LOGS_ORIGIN_FIELD = exports.DEPRECATION_LOGS_ORIGIN_FIELD = 'elasticsearch.elastic_product_origin';
const APP_LOGS_COUNT_INDEX_PRIVILEGES = exports.APP_LOGS_COUNT_INDEX_PRIVILEGES = ['read', 'view_index_metadata'];
const APP_LOGS_COUNT_CLUSTER_PRIVILEGES = exports.APP_LOGS_COUNT_CLUSTER_PRIVILEGES = ['manage_security'];

/**
 * Duration for the "recent" time period (24 hours in milliseconds)
 */
const RECENT_DURATION_MS = exports.RECENT_DURATION_MS = 24 * 60 * 60 * 1000;
const LATEST_VERSION = exports.LATEST_VERSION = '9.1.0';
const MIN_VERSION_TO_UPGRADE_TO_LATEST = exports.MIN_VERSION_TO_UPGRADE_TO_LATEST = '8.19.0';