"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootComponent = exports.App = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _shared_imports = require("../shared_imports");
var _app_context = require("./app_context");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  GlobalFlyoutProvider
} = _shared_imports.GlobalFlyout;
const AppHandlingClusterUpgradeState = () => {
  const {
    services: {
      api,
      core
    }
  } = (0, _app_context.useAppContext)();
  const missingManageSpacesPrivilege = core.application.capabilities.spaces.manage !== true;
  const [clusterUpgradeState, setClusterUpgradeState] = (0, _react.useState)('isPreparingForUpgrade');
  (0, _react.useEffect)(() => {
    api.onClusterUpgradeStateChange(newClusterUpgradeState => {
      setClusterUpgradeState(newClusterUpgradeState);
    });
  }, [api]);
  if (missingManageSpacesPrivilege) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.NotAuthorizedSection, {
      dataTestSubj: "missingKibanaPrivilegesMessage",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.app.deniedPrivilegeTitle",
        defaultMessage: "Kibana admin role required",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 11
        }
      }),
      message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.app.deniedPrivilegeDescription",
        defaultMessage: "To use Upgrade Assistant and resolve deprecation issues, you must have access to manage all Kibana spaces.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 7
      }
    });
  }
  if (clusterUpgradeState === 'isUpgrading') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "logoElasticsearch",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradingTitle",
        defaultMessage: "Your cluster is upgrading",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradingDescription",
        defaultMessage: "One or more Elasticsearch nodes have a newer version of Elasticsearch than Kibana. Once all your nodes are upgraded, upgrade Kibana.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      })),
      "data-test-subj": "isUpgradingMessage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 7
      }
    });
  }
  if (clusterUpgradeState === 'isUpgradeComplete') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      iconType: "logoElasticsearch",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradedTitle",
        defaultMessage: "Your cluster has been upgraded",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.upgradedDescription",
        defaultMessage: "All Elasticsearch nodes have been upgraded. You may now upgrade Kibana.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      })),
      "data-test-subj": "isUpgradeCompleteMessage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/overview",
    component: _components.Overview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/es_deprecations",
    component: _components.EsDeprecations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: "/kibana_deprecations",
    component: _components.KibanaDeprecations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    from: "/",
    to: "/overview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }));
};
const App = ({
  history
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();

  // Poll the API to detect when the cluster is either in the middle of
  // a rolling upgrade or has completed one. We need to create two separate
  // components: one to call this hook and one to handle state changes.
  // This is because the implementation of this hook calls the state-change
  // callbacks on every render, which will get the UI stuck in an infinite
  // render loop if the same component both called the hook and handled
  // the state changes it triggers.
  const {
    isLoading,
    isInitialRequest
  } = api.useLoadClusterUpgradeStatus();

  // Prevent flicker of the underlying UI while we wait for the status to fetch.
  if (isLoading && isInitialRequest) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      body: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "l",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 47
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AppHandlingClusterUpgradeState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }));
};
exports.App = App;
const RootComponent = dependencies => {
  const {
    history,
    core: {
      application,
      http,
      executionContext,
      ...startServices
    }
  } = dependencies.services;
  executionContext.set({
    type: 'application',
    page: 'upgradeAssistant'
  });
  return /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: _shared_imports.APP_WRAPPER_CLASS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.AuthorizationProvider, {
    httpClient: http,
    privilegesEndpoint: `${_constants.API_BASE_PATH}/privileges`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_app_context.AppContextProvider, {
    value: dependencies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(GlobalFlyoutProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(App, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  })))))));
};
exports.RootComponent = RootComponent;