"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepProgress = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/common/step_progress.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getStatusStyles = (euiTheme, colorMode) => {
  const {
    colors,
    size
  } = euiTheme;
  const baseStyle = (0, _react2.css)`
    width: ${size.base};
    height: ${size.base};
    margin-right: ${size.m};
  `;
  const getBackgroundColor = color => (0, _eui.tintOrShade)(color, 0.9, colorMode);
  const getCircleStyle = color => (0, _react2.css)`
    text-align: center;
    border-radius: ${size.m};
    line-height: calc(${size.base} - 2px);
    color: ${(0, _eui.shadeOrTint)((0, _eui.makeHighContrastColor)(color)(getBackgroundColor(color)), 0, colorMode)};
    background-color: ${getBackgroundColor(color)};
  `;
  return {
    info: baseStyle,
    success: (0, _react2.css)`
      ${baseStyle};
      ${getCircleStyle(colors.success)};
    `,
    warning: (0, _react2.css)`
      ${baseStyle};
      ${getCircleStyle(colors.warning)};
    `,
    danger: (0, _react2.css)`
      ${baseStyle};
      ${getCircleStyle(colors.danger)};
    `
  };
};
const StepStatus = ({
  status,
  idx
}) => {
  const {
    euiTheme,
    colorMode
  } = (0, _eui.useEuiTheme)();
  const statusStyles = getStatusStyles(euiTheme, colorMode);
  const statusComponents = {
    incomplete: /*#__PURE__*/_react.default.createElement("span", {
      css: statusStyles.info,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 65,
        columnNumber: 17
      }
    }, idx + 1, "."),
    inProgress: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      css: statusStyles.info,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 17
      }
    }),
    complete: /*#__PURE__*/_react.default.createElement("span", {
      css: statusStyles.success,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    })),
    paused: /*#__PURE__*/_react.default.createElement("span", {
      css: statusStyles.warning,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "pause",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    })),
    cancelled: /*#__PURE__*/_react.default.createElement("span", {
      css: statusStyles.warning,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    })),
    failed: /*#__PURE__*/_react.default.createElement("span", {
      css: statusStyles.danger,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "cross",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 9
      }
    }))
  };
  if (!statusComponents[status]) {
    throw new Error(`Unsupported status: ${status}`);
  }
  return statusComponents[status];
};
const Step = ({
  title,
  status,
  children,
  idx
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    size,
    font
  } = euiTheme;
  const titleStyle = (0, _react2.css)`
    line-height: ${size.l};
    font-weight: ${status === 'inProgress' ? font.weight.bold : 'normal'};
  `;
  const contentStyle = (0, _react2.css)`
    display: block;
    margin-left: calc(${size.base} + ${size.m});
  `;
  const stepProgressStyle = (0, _react2.css)`
    display: flex;
    align-items: center;
    margin-top: ${size.s};
    margin-bottom: ${size.s};
    line-height: ${size.base};

    &:first-child {
      margin-top: ${size.base};
    }
  `;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: stepProgressStyle,
    "data-test-subj": "stepProgressStep",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(StepStatus, {
    status: status,
    idx: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    css: titleStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, title)), children && /*#__PURE__*/_react.default.createElement("div", {
    css: contentStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 20
    }
  }, children));
};
/**
 * A generic component that displays a series of automated steps and the system's progress.
 */
const StepProgress = ({
  steps
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, steps.map((step, idx) => /*#__PURE__*/_react.default.createElement(Step, (0, _extends2.default)({
    key: idx
  }, step, {
    idx: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }))));
};
exports.StepProgress = StepProgress;