"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MigrateDocumentsStepTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _types = require("../../../../../../types");
var _types2 = require("../../../../../../../../../common/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/steps/checklist/progress_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MigrateDocumentsStepTitle = ({
  migrationState: {
    status,
    cancelLoadingState,
    resolutionType
  }
}) => {
  switch (cancelLoadingState) {
    case _types.CancelLoadingState.Requested:
    case _types.CancelLoadingState.Loading:
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.cancelButton.cancellingLabel",
          defaultMessage: "Cancelling\u2026",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 22,
            columnNumber: 9
          }
        });
      }
    case _types.CancelLoadingState.Success:
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.cancelButton.cancelledLabel",
          defaultMessage: "Cancelled",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 30,
            columnNumber: 9
          }
        });
      }
    case _types.CancelLoadingState.Error:
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.cancelButton.errorLabel",
          defaultMessage: "Failed to cancel {resolutionType, select, reindex {reindexing} readonly {read-only} other {}}",
          values: {
            resolutionType
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 38,
            columnNumber: 9
          }
        });
      }
  }
  switch (status) {
    case _types2.DataStreamMigrationStatus.inProgress:
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.inProgress.reindexingDocumentsStepTitle",
          defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} other {}}",
          values: {
            resolutionType
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 50,
            columnNumber: 9
          }
        });
      }
    case _types2.DataStreamMigrationStatus.failed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.failed.reindexingDocumentsStepTitle",
        defaultMessage: "Failed to {resolutionType, select, reindex {reindex} readonly {set to read-only} other {}}",
        values: {
          resolutionType
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 59,
          columnNumber: 9
        }
      });
    case _types2.DataStreamMigrationStatus.fetchFailed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.fetchFailed.reindexingDocumentsStepTitle",
        defaultMessage: "Fetching status failed",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 9
        }
      });
    case _types2.DataStreamMigrationStatus.cancelled:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.cancelled.reindexingDocumentsStepTitle",
        defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} other {}} cancelled",
        values: {
          resolutionType
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 9
        }
      });
    case _types2.DataStreamMigrationStatus.completed:
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.completed.reindexingDocumentsStepTitle",
        defaultMessage: "{resolutionType, select, reindex {Reindexing} readonly {Setting to read-only} other {}} completed",
        values: {
          resolutionType
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      });
    case _types2.DataStreamMigrationStatus.notStarted:
    default:
      {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.upgradeAssistant.dataStream.migration.flyout.checklistStep.reindexingChecklist.inProgress.reindexingDocumentsStepTitle",
          defaultMessage: "{resolutionType, select, reindex {Reindex data stream} readonly {Set data stream to read-only} other {Unknown action}}",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 91,
            columnNumber: 9
          }
        });
      }
  }
};
exports.MigrateDocumentsStepTitle = MigrateDocumentsStepTitle;