"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncompatibleDataInDataStreamWarningCheckbox = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _warning_step_checkbox = require("./warning_step_checkbox");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/data_streams/flyout/steps/confirm/warnings/incompatible_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IncompatibleDataInDataStreamWarningCheckbox = ({
  isChecked,
  onChange,
  id,
  meta
}) => {
  return /*#__PURE__*/_react.default.createElement(_warning_step_checkbox.WarningCheckbox, {
    isChecked: isChecked,
    onChange: onChange,
    warningId: id,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "b",
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.incompatibleDataWarningTitle",
      defaultMessage: "Reindex all incompatible data for this data stream",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 9
      }
    }),
    dataStreamName: meta === null || meta === void 0 ? void 0 : meta.dataStreamName,
    description: meta && typeof meta.indicesRequiringUpgradeCount === 'number' && meta.indicesRequiringUpgradeCount > 0 && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      tagName: "p",
      id: "xpack.upgradeAssistant.dataStream.migration.flyout.warningsStep.incompatibleDataWarningDescription",
      defaultMessage: "{count, plural, =1 {# backing index} other {# backing indices}}, including current write index, will be re-indexed. Current write index will be rolled over first.",
      values: {
        count: meta.indicesRequiringUpgradeCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }),
    "data-test-subj": "incompatibleDataWarningCheckbox",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 17,
      columnNumber: 5
    }
  });
};
exports.IncompatibleDataInDataStreamWarningCheckbox = IncompatibleDataInDataStreamWarningCheckbox;