"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReindexActionCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _context = require("./context");
var _types = require("../../../types");
var _action_buttons = require("../../common/action_buttons");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/actions_table_cell.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const actionsI18nTexts = {
  reindexLoadingActionsText: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexLoadingActionsText', {
    defaultMessage: 'Loading actions…'
  }),
  reindexTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.reindexTooltipLabel', {
    defaultMessage: 'Resolve this issue by reindexing into a new, compatible index.'
  }),
  readOnlyTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.readOnlyTooltipLabel', {
    defaultMessage: 'Resolve this issue by setting this index to read-only.'
  }),
  unfreezeTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.esDeprecations.indices.unfreezeTooltipLabel', {
    defaultMessage: 'Resolve this issue by unfreezing this index.'
  })
};
const UnfreezeActionButtons = ({
  openFlyout,
  correctiveAction,
  setSelectedResolutionType,
  openModal
}) => {
  const {
    reindexState,
    updateIndexState
  } = (0, _context.useIndexContext)();
  const reindexingInProgressOrCompleted = reindexState.status === _upgradeAssistantPkgCommon.ReindexStatus.inProgress || reindexState.status === _upgradeAssistantPkgCommon.ReindexStatus.completed;
  const updateInProgressOrCompleted = updateIndexState.status === 'complete' || updateIndexState.status === 'inProgress';
  const canDisplayUnfreeze = !!(reindexState.hasRequiredPrivileges && !reindexingInProgressOrCompleted);
  const canDisplayReindex = !!(reindexState.hasRequiredPrivileges && !updateInProgressOrCompleted);
  const actions = [{
    tooltip: actionsI18nTexts.reindexTooltipLabel,
    iconType: 'indexSettings',
    canDisplay: canDisplayReindex,
    resolutionType: 'reindex',
    onClick: () => {
      openFlyout();
    }
  }, {
    tooltip: actionsI18nTexts.unfreezeTooltipLabel,
    iconType: 'readOnly',
    canDisplay: canDisplayUnfreeze,
    resolutionType: 'unfreeze',
    onClick: () => {
      openModal();
      setSelectedResolutionType('unfreeze');
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_action_buttons.ActionButtons, {
    actions: actions,
    dataTestSubjPrefix: correctiveAction.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 10
    }
  });
};
const ReindexActionButtons = ({
  openFlyout,
  correctiveAction,
  setSelectedResolutionType,
  openModal
}) => {
  const {
    excludedActions = []
  } = correctiveAction;
  const {
    reindexState,
    updateIndexState
  } = (0, _context.useIndexContext)();
  const {
    meta
  } = reindexState;
  const {
    isReadonly,
    isFollowerIndex
  } = meta;
  const reindexingInProgressOrCompleted = reindexState.status === _upgradeAssistantPkgCommon.ReindexStatus.inProgress || reindexState.status === _upgradeAssistantPkgCommon.ReindexStatus.completed;
  const updateInProgressOrCompleted = updateIndexState.status === 'complete' || updateIndexState.status === 'inProgress';
  const readOnlyExcluded = excludedActions.includes('readOnly');
  const reindexExcluded = excludedActions.includes('reindex');
  const canDisplayReadOnly = !!(reindexState.hasRequiredPrivileges && !readOnlyExcluded && !isReadonly && !reindexingInProgressOrCompleted);
  const canDisplayReindex = !!(reindexState.hasRequiredPrivileges && !reindexExcluded && !isFollowerIndex && !updateInProgressOrCompleted);
  const actions = [{
    tooltip: actionsI18nTexts.reindexTooltipLabel,
    iconType: 'indexSettings',
    canDisplay: canDisplayReindex,
    resolutionType: 'reindex',
    onClick: () => {
      openFlyout();
    }
  }, {
    tooltip: actionsI18nTexts.readOnlyTooltipLabel,
    iconType: 'readOnly',
    canDisplay: canDisplayReadOnly,
    resolutionType: 'readonly',
    onClick: () => {
      openModal();
      setSelectedResolutionType('readonly');
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_action_buttons.ActionButtons, {
    actions: actions,
    dataTestSubjPrefix: correctiveAction.type,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 10
    }
  });
};
const ReindexActionCell = ({
  openFlyout,
  setSelectedResolutionType,
  openModal
}) => {
  var _deprecation$correcti;
  const {
    reindexState,
    deprecation
  } = (0, _context.useIndexContext)();
  const correctiveAction = (_deprecation$correcti = deprecation.correctiveAction) === null || _deprecation$correcti === void 0 ? void 0 : _deprecation$correcti.type;
  if (reindexState.loadingState === _types.LoadingState.Loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 11
      }
    }, actionsI18nTexts.reindexLoadingActionsText)));
  }
  return correctiveAction === 'unfreeze' ? /*#__PURE__*/_react.default.createElement(UnfreezeActionButtons, {
    openFlyout: openFlyout,
    correctiveAction: deprecation.correctiveAction,
    setSelectedResolutionType: setSelectedResolutionType,
    openModal: openModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(ReindexActionButtons, {
    openFlyout: openFlyout,
    correctiveAction: deprecation.correctiveAction,
    setSelectedResolutionType: setSelectedResolutionType,
    openModal: openModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  });
};
exports.ReindexActionCell = ReindexActionCell;