"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexContext = exports.IndexStatusProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_reindex = require("./use_reindex");
var _use_update_index = require("./use_update_index");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useIndexContext = () => {
  const context = (0, _react.useContext)(IndexContext);
  if (context === undefined) {
    throw new Error('useIndexContext must be used within a <IndexStatusProvider />');
  }
  return context;
};
exports.useIndexContext = useIndexContext;
const IndexStatusProvider = ({
  api,
  deprecation,
  children,
  version
}) => {
  const indexName = deprecation.index;
  const indexAction = deprecation.correctiveAction;
  const {
    reindexState,
    startReindex,
    cancelReindex
  } = (0, _use_reindex.useReindex)({
    indexName,
    api,
    isInDataStream: Boolean(indexAction === null || indexAction === void 0 ? void 0 : indexAction.metadata.isInDataStream),
    isFrozen: Boolean(indexAction === null || indexAction === void 0 ? void 0 : indexAction.metadata.isFrozenIndex),
    isClosedIndex: Boolean(indexAction === null || indexAction === void 0 ? void 0 : indexAction.metadata.isClosedIndex),
    kibanaVersion: version
  });
  const {
    updateIndexState,
    updateIndex
  } = (0, _use_update_index.useUpdateIndex)({
    indexName,
    api,
    correctiveAction: deprecation.correctiveAction
  });
  return /*#__PURE__*/_react.default.createElement(IndexContext.Provider, {
    value: {
      deprecation,
      reindexState,
      startReindex,
      cancelReindex,
      updateIndexState,
      updateIndex
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, children);
};
exports.IndexStatusProvider = IndexStatusProvider;