"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _shared = require("../../../../shared");
var _ui_metric = require("../../../../../lib/ui_metric");
var _initializing_step = require("../../../common/initializing_step");
var _warning_step = require("./steps/warning/warning_step");
var _reindex_step = require("./steps/reindex/reindex_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/flyout/container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexFlyout = ({
  reindexState,
  startReindex,
  cancelReindex,
  updateIndexState,
  closeFlyout,
  deprecation
}) => {
  const {
    status: reindexStatus,
    reindexWarnings,
    errorMessage
  } = reindexState;
  const {
    status: updateIndexStatus
  } = updateIndexState;
  const {
    index
  } = deprecation;
  const [flyoutStep, setFlyoutStep] = (0, _react.useState)('initializing');
  const onStartReindex = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_START_CLICK);
    startReindex();
  }, [startReindex]);
  const onStopReindex = (0, _react.useCallback)(() => {
    _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_REINDEX_STOP_CLICK);
    cancelReindex();
  }, [cancelReindex]);
  (0, _react.useEffect)(() => {
    switch (reindexStatus) {
      case _upgradeAssistantPkgCommon.ReindexStatus.failed:
      case _upgradeAssistantPkgCommon.ReindexStatus.fetchFailed:
      case _upgradeAssistantPkgCommon.ReindexStatus.cancelled:
      case _upgradeAssistantPkgCommon.ReindexStatus.inProgress:
      case _upgradeAssistantPkgCommon.ReindexStatus.completed:
        {
          setFlyoutStep('reindexing');
          break;
        }
      default:
        {
          setFlyoutStep('confirmReindex');
          break;
        }
    }
  }, [reindexStatus]);
  const startReindexWithWarnings = (0, _react.useCallback)(() => {
    if (reindexWarnings && reindexWarnings.length > 0 && reindexStatus !== _upgradeAssistantPkgCommon.ReindexStatus.inProgress && reindexStatus !== _upgradeAssistantPkgCommon.ReindexStatus.completed) {
      setFlyoutStep('confirmReindex');
    } else {
      onStartReindex();
    }
  }, [reindexWarnings, reindexStatus, onStartReindex]);
  const flyoutContents = (0, _react.useMemo)(() => {
    var _reindexState$reindex, _reindexState$reindex2;
    switch (flyoutStep) {
      case 'initializing':
        return /*#__PURE__*/_react.default.createElement(_initializing_step.InitializingStep, {
          errorMessage: errorMessage,
          type: "index",
          mode: "flyout",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 90,
            columnNumber: 16
          }
        });
      case 'confirmReindex':
        return /*#__PURE__*/_react.default.createElement(_warning_step.WarningFlyoutStep, {
          warnings: (_reindexState$reindex = (_reindexState$reindex2 = reindexState.reindexWarnings) === null || _reindexState$reindex2 === void 0 ? void 0 : _reindexState$reindex2.filter(({
            flow: warningFlow
          }) => warningFlow === 'all' || warningFlow === 'reindex')) !== null && _reindexState$reindex !== void 0 ? _reindexState$reindex : [],
          meta: reindexState.meta,
          closeFlyout: closeFlyout,
          confirm: () => {
            onStartReindex();
          },
          deprecation: deprecation,
          reindexState: reindexState,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 11
          }
        });
      case 'reindexing':
        return /*#__PURE__*/_react.default.createElement(_reindex_step.ReindexFlyoutStep, {
          closeFlyout: closeFlyout,
          startReindex: startReindexWithWarnings,
          reindexState: reindexState,
          cancelReindex: onStopReindex,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 110,
            columnNumber: 11
          }
        });
    }
  }, [closeFlyout, deprecation, errorMessage, flyoutStep, onStartReindex, onStopReindex, reindexState, startReindexWithWarnings]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
    level: deprecation.level,
    isResolved: reindexStatus === _upgradeAssistantPkgCommon.ReindexStatus.completed || updateIndexStatus === 'complete',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "reindexDetailsFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.flyoutHeader",
    defaultMessage: "Reindex {index}",
    values: {
      index
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  })))), flyoutContents);
};
exports.IndexFlyout = IndexFlyout;