"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idForWarning = exports.WarningFlyoutStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _app_context = require("../../../../../../../app_context");
var _warning_step_checkbox = require("./warning_step_checkbox");
var _callouts = require("../callouts");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/flyout/steps/warning/warning_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ML_ANOMALIES_PREFIX = '.ml-anomalies-';
const warningToComponentMap = {
  indexSetting: _warning_step_checkbox.DeprecatedSettingWarningCheckbox,
  replaceIndexWithAlias: _warning_step_checkbox.ReplaceIndexWithAliasWarningCheckbox,
  makeIndexReadonly: _warning_step_checkbox.MakeIndexReadonlyWarningCheckbox
};
const idForWarning = id => `reindexWarning-${id}`;
exports.idForWarning = idForWarning;
/**
 * Displays warning text about destructive changes required to reindex this index. The user
 * must acknowledge each change before being allowed to proceed.
 */
const WarningFlyoutStep = ({
  closeFlyout,
  confirm,
  meta,
  warnings,
  deprecation,
  reindexState
}) => {
  var _correctiveAction$tra;
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    links
  } = docLinks;
  const [checkedIds, setCheckedIds] = (0, _react.useState)(warnings.reduce((initialCheckedIds, warning, index) => {
    initialCheckedIds[idForWarning(index)] = false;
    return initialCheckedIds;
  }, {}));
  const {
    meta: {
      indexName
    },
    status: reindexStatus
  } = reindexState;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const hasFetchFailed = reindexStatus === _upgradeAssistantPkgCommon.ReindexStatus.fetchFailed;
  const hasReindexingFailed = reindexStatus === _upgradeAssistantPkgCommon.ReindexStatus.failed;
  const correctiveAction = deprecation === null || deprecation === void 0 ? void 0 : deprecation.correctiveAction;
  const isESTransformTarget = !!(correctiveAction !== null && correctiveAction !== void 0 && (_correctiveAction$tra = correctiveAction.transformIds) !== null && _correctiveAction$tra !== void 0 && _correctiveAction$tra.length);
  const isMLAnomalyIndex = Boolean(indexName === null || indexName === void 0 ? void 0 : indexName.startsWith(ML_ANOMALIES_PREFIX));

  // Do not allow to proceed until all checkboxes are checked.
  const blockAdvance = Object.values(checkedIds).filter(v => v).length < warnings.length;
  const onChange = e => {
    const optionId = e.target.id;
    setCheckedIds(prev => ({
      ...prev,
      ...{
        [optionId]: !checkedIds[optionId]
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 28
    }
  }), !hasFetchFailed && hasReindexingFailed && /*#__PURE__*/_react.default.createElement(_callouts.ReindexingFailedCallOut, {
    errorMessage: reindexState.errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 39
    }
  }), meta.isFrozen && /*#__PURE__*/_react.default.createElement(_callouts.FrozenCallOut, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 27
    }
  }), meta.isFollowerIndex && /*#__PURE__*/_react.default.createElement(_callouts.FollowerIndexCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 34
    }
  }), isESTransformTarget && /*#__PURE__*/_react.default.createElement(_callouts.ESTransformsTargetCallout, {
    deprecation: deprecation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 33
    }
  }), isMLAnomalyIndex && /*#__PURE__*/_react.default.createElement(_callouts.MlAnomalyCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 30
    }
  }), warnings.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.reindex.calloutTitle",
      defaultMessage: "This index requires destructive changes that cannot be reversed",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.reindex.calloutDetail",
    defaultMessage: "Back up the index before continuing. To proceed with the reindex, accept each change.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.acceptChangesTitle",
    defaultMessage: "Accept changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  }), warnings.map((warning, index) => {
    const WarningCheckbox = warningToComponentMap[warning.warningType];
    return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
      key: idForWarning(index),
      isChecked: checkedIds[idForWarning(index)],
      onChange: onChange,
      docLinks: links,
      id: idForWarning(index),
      meta: {
        ...meta,
        ...warning.meta
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    flush: "left",
    "data-test-subj": "closeReindexButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.closeButtonLabel",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: confirm,
    disabled: blockAdvance,
    "data-test-subj": "startReindexingButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexFlyout.warningsStep.reindex.continueButtonLabel",
    defaultMessage: "Continue reindexing",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 15
    }
  }))))));
};
exports.WarningFlyoutStep = WarningFlyoutStep;