"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.idForWarning = exports.WarningModalStep = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _upgradeAssistantPkgCommon = require("@kbn/upgrade-assistant-pkg-common");
var _app_context = require("../../../../../../../app_context");
var _warning_step_checkbox = require("./warning_step_checkbox");
var _callouts = require("../callouts");
var _nodes_low_disk_space = require("../../../../../common/nodes_low_disk_space");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/indices/flyout/steps/warning/warning_step_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ML_ANOMALIES_PREFIX = '.ml-anomalies-';
const warningToComponentMap = {
  indexSetting: _warning_step_checkbox.DeprecatedSettingWarningCheckbox,
  replaceIndexWithAlias: _warning_step_checkbox.ReplaceIndexWithAliasWarningCheckbox,
  makeIndexReadonly: _warning_step_checkbox.MakeIndexReadonlyWarningCheckbox
};
const idForWarning = id => `reindexWarning-${id}`;
exports.idForWarning = idForWarning;
const WarningModalStep = props => {
  return props.flow === 'readonly' ? /*#__PURE__*/_react.default.createElement(WarningReadOnlyModalStep, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(WarningUnfreezeModalStep, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }));
};
exports.WarningModalStep = WarningModalStep;
const WarningUnfreezeModalStep = ({
  confirm,
  reindexState,
  closeModal
}) => {
  const {
    services: {
      api
    }
  } = (0, _app_context.useAppContext)();
  const {
    status: reindexStatus,
    meta: {
      indexName
    }
  } = reindexState;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const hasFetchFailed = reindexStatus === _upgradeAssistantPkgCommon.ReindexStatus.fetchFailed;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "updateIndexModalTitle",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.unfreeze.title",
    defaultMessage: "Unfreeze index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.unfreeze.calloutDetail",
    defaultMessage: "Unfreeze {indexName}. This action will also set it to read-only. This ensures that the index will remain compatible with the next major version.",
    values: {
      indexName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 34
        }
      }, indexName)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 28
    }
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 39
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    color: "primary",
    "data-test-subj": "startIndexUnfreezeCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: confirm,
    "data-test-subj": "startIndexUnfreezeButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.continueButtonLabel",
    "data-test-subj": "startIndexUnfreezeButton",
    defaultMessage: "Unfreeze index",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  })))));
};
const WarningReadOnlyModalStep = ({
  confirm,
  meta,
  warnings,
  deprecation,
  reindexState,
  closeModal
}) => {
  var _correctiveAction$tra;
  const {
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const {
    links
  } = docLinks;
  const [checkedIds, setCheckedIds] = (0, _react.useState)(warnings.reduce((initialCheckedIds, warning, index) => {
    initialCheckedIds[idForWarning(index)] = false;
    return initialCheckedIds;
  }, {}));
  const {
    meta: {
      indexName
    },
    status: reindexStatus
  } = reindexState;
  const {
    data: nodes
  } = api.useLoadNodeDiskSpace();
  const hasFetchFailed = reindexStatus === _upgradeAssistantPkgCommon.ReindexStatus.fetchFailed;
  const correctiveAction = deprecation === null || deprecation === void 0 ? void 0 : deprecation.correctiveAction;
  const isESTransformTarget = !!(correctiveAction !== null && correctiveAction !== void 0 && (_correctiveAction$tra = correctiveAction.transformIds) !== null && _correctiveAction$tra !== void 0 && _correctiveAction$tra.length);
  const isMLAnomalyIndex = Boolean(indexName === null || indexName === void 0 ? void 0 : indexName.startsWith(ML_ANOMALIES_PREFIX));

  // Do not allow to proceed until all checkboxes are checked.
  const blockAdvance = Object.values(checkedIds).filter(v => v).length < warnings.length;
  const onChange = e => {
    const optionId = e.target.id;
    setCheckedIds(prev => ({
      ...prev,
      ...{
        [optionId]: !checkedIds[optionId]
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    "data-test-subj": "updateIndexModalTitle",
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.title",
    defaultMessage: "Set index to read-only",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.description",
    defaultMessage: "Old indices can maintain compatibility with the next major version if they are turned into read-only mode. If you no longer need to update documents in this index (or add new ones), it\u2019s recommended to set it to read-only index.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }), hasFetchFailed && /*#__PURE__*/_react.default.createElement(_callouts.FetchFailedCallOut, {
    errorMessage: reindexState.errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 28
    }
  }), nodes && nodes.length > 0 && /*#__PURE__*/_react.default.createElement(_nodes_low_disk_space.NodesLowSpaceCallOut, {
    nodes: nodes,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 39
    }
  }), meta.isFollowerIndex && /*#__PURE__*/_react.default.createElement(_callouts.FollowerIndexCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 34
    }
  }), isESTransformTarget && /*#__PURE__*/_react.default.createElement(_callouts.ESTransformsTargetCallout, {
    deprecation: deprecation,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 33
    }
  }), isMLAnomalyIndex && /*#__PURE__*/_react.default.createElement(_callouts.MlAnomalyCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 30
    }
  }), warnings.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.calloutTitle",
      defaultMessage: "Enable compatibility by setting this index to read-only",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 17
      }
    }),
    color: "warning",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.calloutDetail",
    defaultMessage: "Note that any attempts to insert new documents or update existing ones will fail. You can choose to reindex after upgrading if needed, to convert the index into a writable one.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.acceptChangesTitle",
    defaultMessage: "Accept changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 13
    }
  }), warnings.map((warning, index) => {
    const WarningCheckbox = warningToComponentMap[warning.warningType];
    return /*#__PURE__*/_react.default.createElement(WarningCheckbox, {
      key: idForWarning(index),
      isChecked: checkedIds[idForWarning(index)],
      onChange: onChange,
      docLinks: links,
      id: idForWarning(index),
      meta: {
        ...meta,
        ...warning.meta
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 17
      }
    });
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal,
    color: "primary",
    "data-test-subj": "warningModalCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: confirm,
    disabled: blockAdvance,
    "data-test-subj": "startIndexReadonlyButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.esDeprecations.indices.indexModal.warningsStep.readonly.continueButtonLabel",
    "data-test-subj": "startIndexReadonlyButton",
    defaultMessage: "Set to read-only",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  })))));
};