"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMlSnapshotContext = exports.MlSnapshotsStatusProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_snapshot_state = require("./use_snapshot_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/es_deprecations/deprecation_types/ml_snapshots/context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlSnapshotsContext = /*#__PURE__*/(0, _react.createContext)(undefined);
const useMlSnapshotContext = () => {
  const context = (0, _react.useContext)(MlSnapshotsContext);
  if (context === undefined) {
    throw new Error('useMlSnapshotContext must be used within a <MlSnapshotsStatusProvider />');
  }
  return context;
};
exports.useMlSnapshotContext = useMlSnapshotContext;
const MlSnapshotsStatusProvider = ({
  api,
  snapshotId,
  jobId,
  mlUpgradeModeEnabled,
  children
}) => {
  const {
    updateSnapshotStatus,
    snapshotState,
    upgradeSnapshot,
    deleteSnapshot
  } = (0, _use_snapshot_state.useSnapshotState)({
    jobId,
    snapshotId,
    api
  });
  (0, _react.useEffect)(() => {
    updateSnapshotStatus();
  }, [updateSnapshotStatus]);
  return /*#__PURE__*/_react.default.createElement(MlSnapshotsContext.Provider, {
    value: {
      snapshotState,
      upgradeSnapshot,
      deleteSnapshot,
      mlUpgradeModeEnabled
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, children);
};
exports.MlSnapshotsStatusProvider = MlSnapshotsStatusProvider;