"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaDeprecationsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _resolution_table_cell = require("./resolution_table_cell");
var _shared = require("../shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/kibana_deprecations/kibana_deprecations_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  refreshButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.refreshButtonLabel', {
    defaultMessage: 'Refresh'
  }),
  statusColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.statusColumnTitle', {
    defaultMessage: 'Status'
  }),
  issueColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.issueColumnTitle', {
    defaultMessage: 'Issue'
  }),
  typeColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.typeColumnTitle', {
    defaultMessage: 'Type'
  }),
  resolutionColumnTitle: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.resolutionColumnTitle', {
    defaultMessage: 'Resolution'
  }),
  configDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.configDeprecationTypeCellLabel', {
    defaultMessage: 'Config'
  }),
  featureDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.featureDeprecationTypeCellLabel', {
    defaultMessage: 'Feature'
  }),
  apiDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.apiDeprecationTypeCellLabel', {
    defaultMessage: 'API'
  }),
  unknownDeprecationTypeCellLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.unknownDeprecationTypeCellLabel', {
    defaultMessage: 'Uncategorized'
  }),
  typeFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.typeFilterLabel', {
    defaultMessage: 'Type'
  }),
  statusFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.statusFilterLabel', {
    defaultMessage: 'Status'
  }),
  criticalFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.criticalFilterLabel', {
    defaultMessage: 'Critical'
  }),
  warningFilterLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.warningFilterLabel', {
    defaultMessage: 'Warning'
  }),
  searchPlaceholderLabel: _i18n.i18n.translate('xpack.upgradeAssistant.kibanaDeprecations.table.searchPlaceholderLabel', {
    defaultMessage: 'Filter'
  })
};
const KibanaDeprecationsTable = ({
  deprecations,
  reload,
  toggleFlyout,
  deprecationResolutionStates
}) => {
  const columns = [{
    field: 'level',
    name: i18nTexts.statusColumnTitle,
    width: '5%',
    truncateText: true,
    sortable: true,
    render: level => {
      return /*#__PURE__*/_react.default.createElement(_shared.DeprecationBadge, {
        level: level,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 16
        }
      });
    }
  }, {
    field: 'title',
    width: '40%',
    name: i18nTexts.issueColumnTitle,
    truncateText: true,
    sortable: true,
    render: (title, deprecation) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: () => toggleFlyout(deprecation),
        "data-test-subj": "deprecationDetailsLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 11
        }
      }, title);
    }
  }, {
    field: 'filterType',
    name: i18nTexts.typeColumnTitle,
    width: '20%',
    truncateText: true,
    sortable: true,
    render: filterType => {
      switch (filterType) {
        case 'config':
          return i18nTexts.configDeprecationTypeCellLabel;
        case 'feature':
          return i18nTexts.featureDeprecationTypeCellLabel;
        case 'api':
          return i18nTexts.apiDeprecationTypeCellLabel;
        case 'uncategorized':
        default:
          return i18nTexts.unknownDeprecationTypeCellLabel;
      }
    }
  }, {
    field: 'correctiveActions',
    name: i18nTexts.resolutionColumnTitle,
    width: '30%',
    truncateText: true,
    sortable: true,
    render: (correctiveActions, deprecation) => {
      return /*#__PURE__*/_react.default.createElement(_resolution_table_cell.ResolutionTableCell, {
        deprecationId: deprecation.id,
        isAutomated: Boolean(correctiveActions === null || correctiveActions === void 0 ? void 0 : correctiveActions.api),
        canBeMarkedAsResolved: Boolean(correctiveActions === null || correctiveActions === void 0 ? void 0 : correctiveActions.mark_as_resolved_api),
        deprecationResolutionState: deprecationResolutionStates[deprecation.id],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 11
        }
      });
    }
  }];
  const sorting = {
    sort: {
      field: 'level',
      direction: 'asc'
    }
  };
  const searchConfig = {
    filters: [{
      type: 'field_value_selection',
      field: 'level',
      name: i18nTexts.statusFilterLabel,
      multiSelect: false,
      options: [{
        value: 'critical',
        name: i18nTexts.criticalFilterLabel
      }, {
        value: 'warning',
        name: i18nTexts.warningFilterLabel
      }]
    }, {
      type: 'field_value_selection',
      field: 'filterType',
      name: i18nTexts.typeFilterLabel,
      multiSelect: false,
      options: [{
        value: 'config',
        name: i18nTexts.configDeprecationTypeCellLabel
      }, {
        value: 'feature',
        name: i18nTexts.featureDeprecationTypeCellLabel
      }, {
        value: 'api',
        name: i18nTexts.apiDeprecationTypeCellLabel
      }, {
        value: 'uncategorized',
        name: i18nTexts.unknownDeprecationTypeCellLabel
      }]
    }],
    box: {
      incremental: true,
      placeholder: i18nTexts.searchPlaceholderLabel
    },
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "refreshButton",
      key: "refreshButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 242,
        columnNumber: 7
      }
    }, i18nTexts.refreshButtonLabel)]
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: deprecations || [],
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    pagination: _constants.PAGINATION_CONFIG,
    rowProps: deprecation => ({
      'data-test-subj': 'row',
      onClick: () => {
        toggleFlyout(deprecation);
      }
    }),
    cellProps: (deprecation, field) => ({
      'data-test-subj': `${((field === null || field === void 0 ? void 0 : field.name) || 'table').toLowerCase()}Cell`
    }),
    "data-test-subj": "kibanaDeprecationsTable",
    tableLayout: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 5
    }
  });
};
exports.KibanaDeprecationsTable = KibanaDeprecationsTable;