"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnPremBackup = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _app_context = require("../../../app_context");
var _ui_metric = require("../../../lib/ui_metric");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/backup_step/on_prem_backup.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SnapshotRestoreAppLink = () => {
  var _share$url$locators$g;
  const {
    plugins: {
      share
    }
  } = (0, _app_context.useAppContext)();
  const snapshotRestoreUrl = (_share$url$locators$g = share.url.locators.get('SNAPSHOT_RESTORE_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({
    page: 'snapshots'
  });
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiButton, {
      href: snapshotRestoreUrl,
      target: "_blank",
      onClick: () => {
        _ui_metric.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metric.UIM_BACKUP_DATA_ON_PREM_CLICK);
      },
      "data-test-subj": "snapshotRestoreLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 5
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.snapshotRestoreLink",
      defaultMessage: "Create snapshot",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 7
      }
    }))
  );
};
const OnPremBackup = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.upgradeAssistant.overview.backupStepDescription', {
    defaultMessage: 'Make sure you have a current snapshot before proceeding.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(SnapshotRestoreAppLink, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }));
};
exports.OnPremBackup = OnPremBackup;