"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaDeprecationIssuesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../../app_context");
var _deprecation_issues_panel = require("./deprecation_issues_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/fix_issues_step/components/kibana_deprecation_issues_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KibanaDeprecationIssuesPanel = ({
  setIsFixed
}) => {
  var _kibanaDeprecations$f, _kibanaDeprecations$f2, _kibanaDeprecations$f3, _kibanaDeprecations$f4;
  const {
    services: {
      core: {
        deprecations
      }
    }
  } = (0, _app_context.useAppContext)();
  const [kibanaDeprecations, setKibanaDeprecations] = (0, _react.useState)(undefined);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    async function getAllDeprecations() {
      setIsLoading(true);
      try {
        const response = await deprecations.getAllDeprecations();
        setKibanaDeprecations(response);
      } catch (e) {
        setError(e);
      }
      setIsLoading(false);
    }
    getAllDeprecations();
  }, [deprecations]);
  const criticalDeprecationsCount = (_kibanaDeprecations$f = kibanaDeprecations === null || kibanaDeprecations === void 0 ? void 0 : (_kibanaDeprecations$f2 = kibanaDeprecations.filter(deprecation => deprecation.level === 'critical')) === null || _kibanaDeprecations$f2 === void 0 ? void 0 : _kibanaDeprecations$f2.length) !== null && _kibanaDeprecations$f !== void 0 ? _kibanaDeprecations$f : 0;
  const warningDeprecationsCount = (_kibanaDeprecations$f3 = kibanaDeprecations === null || kibanaDeprecations === void 0 ? void 0 : (_kibanaDeprecations$f4 = kibanaDeprecations.filter(deprecation => deprecation.level === 'warning')) === null || _kibanaDeprecations$f4 === void 0 ? void 0 : _kibanaDeprecations$f4.length) !== null && _kibanaDeprecations$f3 !== void 0 ? _kibanaDeprecations$f3 : 0;
  const errorMessage = error && _i18n.i18n.translate('xpack.upgradeAssistant.deprecationStats.loadingErrorMessage', {
    defaultMessage: 'Could not retrieve Kibana deprecation issues.'
  });
  return /*#__PURE__*/_react.default.createElement(_deprecation_issues_panel.DeprecationIssuesPanel, {
    "data-test-subj": "kibanaStatsPanel",
    deprecationSource: "Kibana",
    linkUrl: "/kibana_deprecations",
    criticalDeprecationsCount: criticalDeprecationsCount,
    warningDeprecationsCount: warningDeprecationsCount,
    isLoading: isLoading,
    errorMessage: errorMessage,
    setIsFixed: setIsFixed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.KibanaDeprecationIssuesPanel = KibanaDeprecationIssuesPanel;