"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemIndicesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _migrate_button = require("./migrate_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/migrate_system_indices/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nTexts = {
  closeButtonLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutCloseButtonLabel', {
    defaultMessage: 'Close'
  }),
  flyoutTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutTitle', {
    defaultMessage: 'Migrate system indices'
  }),
  flyoutDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.flyoutDescription', {
    defaultMessage: 'Migrate the indices that store information for the following features before you upgrade.'
  }),
  migrationCompleteLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migrationCompleteLabel', {
    defaultMessage: 'Migration complete'
  }),
  needsMigrationLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.needsMigrationLabel', {
    defaultMessage: 'Migration required'
  }),
  migratingLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migratingLabel', {
    defaultMessage: 'Migration in progress'
  }),
  errorLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.errorLabel', {
    defaultMessage: 'Migration failed'
  }),
  featureNameTableColumn: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.featureNameTableColumn', {
    defaultMessage: 'Feature'
  }),
  statusTableColumn: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.statusTableColumn', {
    defaultMessage: 'Status'
  }),
  errorTooltipLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.errorTooltipLabel', {
    defaultMessage: 'Migration failed for the following indices: '
  }),
  unknownErrorLabel: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.unknownErrorLabel', {
    defaultMessage: 'Unknown error'
  }),
  migrationNotNeeded: _i18n.i18n.translate('xpack.upgradeAssistant.overview.systemIndices.migrationNotNeeded', {
    defaultMessage: 'Systems indices migration not needed'
  })
};
const getFailedIndices = feature => {
  return feature.indices.filter(index => index.failure_cause && index.failure_cause.error).map(index => {
    var _index$failure_cause;
    return {
      index: index.index,
      reason: index === null || index === void 0 ? void 0 : (_index$failure_cause = index.failure_cause) === null || _index$failure_cause === void 0 ? void 0 : _index$failure_cause.error.type
    };
  });
};
const renderMigrationStatus = status => {
  if (status === 'NO_MIGRATION_NEEDED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "checkInCircleFilled",
      color: "success",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "green",
      size: "s",
      "data-test-subj": "featureNoUpgradeNeeded",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 13
      }
    }, i18nTexts.migrationCompleteLabel))));
  }
  if (status === 'MIGRATION_NEEDED') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      "data-test-subj": "featureUpgradeNeeded",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 9
      }
    }, i18nTexts.needsMigrationLabel));
  }
  if (status === 'IN_PROGRESS') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "featureInProgress",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }, i18nTexts.migratingLabel))));
  }
  if (status === 'ERROR') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warning",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      size: "s",
      "data-test-subj": "featureError",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, i18nTexts.errorLabel))));
  }
  return null;
};
const SystemIndicesFlyout = ({
  closeFlyout,
  data,
  beginSystemIndicesMigration,
  isInitialRequest,
  isLoading,
  migrationStatus
}) => {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  const toggleRow = feature => {
    setExpandedRows(prev => {
      const newRows = {
        ...prev
      };
      if (newRows[feature.feature_name]) {
        delete newRows[feature.feature_name];
      } else {
        const failedIndices = getFailedIndices(feature);
        const errorDetails = failedIndices.map(({
          index,
          reason
        }) => ({
          title: index,
          description: reason || i18nTexts.unknownErrorLabel
        }));
        newRows[feature.feature_name] = /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
          listItems: errorDetails,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 41
          }
        });
      }
      return newRows;
    });
  };
  const columns = [{
    field: 'feature_name',
    name: i18nTexts.featureNameTableColumn,
    sortable: true,
    truncateText: true,
    render: name => (0, _lodash.startCase)(name)
  }, {
    field: 'migration_status',
    name: i18nTexts.statusTableColumn,
    sortable: true,
    render: renderMigrationStatus
  }, {
    align: 'right',
    width: '40px',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 229,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.upgradeAssistant.overview.systemIndices.expandRow",
      defaultMessage: "Expand row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 231,
        columnNumber: 13
      }
    }))),
    render: feature => {
      return feature.migration_status === 'ERROR' ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        onClick: () => toggleRow(feature),
        "aria-label": expandedRows[feature.feature_name] ? 'Collapse' : 'Expand',
        iconType: expandedRows[feature.feature_name] ? 'arrowDown' : 'arrowRight',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 11
        }
      }) : null;
    }
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    "data-test-subj": "flyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "migrateSystemIndicesFlyoutTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 11
    }
  }, i18nTexts.flyoutTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "flyoutDetails",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, migrationStatus === 'NO_MIGRATION_NEEDED' && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18nTexts.migrationNotNeeded,
    iconType: "cheer",
    color: "success",
    "data-test-subj": "noMigrationNeededCallout",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  }), migrationStatus !== 'NO_MIGRATION_NEEDED' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 15
    }
  }, i18nTexts.flyoutDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    "data-test-subj": "featuresTable",
    itemId: "feature_name",
    items: data.features,
    columns: columns,
    itemIdToExpandedRowMap: expandedRows,
    pagination: true,
    sorting: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 273,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout,
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 13
    }
  }, i18nTexts.closeButtonLabel)), migrationStatus !== 'NO_MIGRATION_NEEDED' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_migrate_button.MigrateSystemIndicesButton, {
    buttonProps: {
      fill: true
    },
    beginSystemIndicesMigration: beginSystemIndicesMigration,
    isInitialRequest: isInitialRequest,
    isLoading: isLoading,
    isMigrating: migrationStatus === 'IN_PROGRESS',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 15
    }
  })))));
};
exports.SystemIndicesFlyout = SystemIndicesFlyout;