"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUpgradeStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/overview/upgrade_step/upgrade_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  upgradeStepTitle: _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeStepTitle', {
    defaultMessage: 'Upgrade the Elastic Stack'
  }),
  upgradeStepDescription: _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeStepDescription', {
    defaultMessage: 'Once you’ve resolved all critical issues and verified that your applications are ready, you can upgrade to the next version of the Elastic Stack. Be sure to back up your data again before upgrading.'
  }),
  upgradeStepDescriptionForCloud: _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeStepDescriptionForCloud', {
    defaultMessage: "Once you've resolved all critical issues and verified that your applications are ready, you can upgrade to the next version of the Elastic Stack. Be sure to back up your data again before upgrading. Upgrade your deployment on Elastic Cloud."
  }),
  upgradeStepCloudLink: _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeStepCloudLink', {
    defaultMessage: 'Upgrade on Cloud'
  }),
  loadingUpgradeStatus: _i18n.i18n.translate('xpack.upgradeAssistant.overview.loadingUpgradeStatus', {
    defaultMessage: 'Loading upgrade status'
  }),
  upgradeGuideLink: _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeGuideLink', {
    defaultMessage: 'View upgrade guide'
  })
};
const UpgradeStep = () => {
  const {
    plugins: {
      cloud
    },
    services: {
      api,
      core: {
        docLinks
      }
    }
  } = (0, _app_context.useAppContext)();
  const isCloudEnabled = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled);
  const {
    data: upgradeStatus,
    isLoading,
    error,
    resendRequest
  } = api.useLoadUpgradeStatus();
  let callToAction;
  if (isCloudEnabled) {
    if (error) {
      callToAction = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.upgradeAssistant.overview.errorLoadingUpgradeStatus', {
          defaultMessage: 'An error occurred while retrieving the upgrade status'
        }),
        color: "danger",
        iconType: "warning",
        "data-test-subj": "upgradeStatusErrorCallout",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 11
        }
      }, error.statusCode, " - ", error.message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "danger",
        onClick: resendRequest,
        "data-test-subj": "upgradeStatusRetryButton",
        isLoading: isLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.upgradeAssistant.overview.upgradeStatus.retryButton', {
        defaultMessage: 'Try again'
      })));
    } else {
      const readyForUpgrade = upgradeStatus === null || upgradeStatus === void 0 ? void 0 : upgradeStatus.readyForUpgrade;
      const upgradeOnCloudUrl = cloud.deploymentUrl + '?show_upgrade=true';
      callToAction = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        href: upgradeOnCloudUrl,
        target: "_blank",
        "data-test-subj": "upgradeSetupCloudLink",
        iconSide: "right",
        iconType: "popout",
        isLoading: isLoading,
        isDisabled: !readyForUpgrade,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 95,
          columnNumber: 13
        }
      }, isLoading ? i18nTexts.loadingUpgradeStatus : i18nTexts.upgradeStepCloudLink)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 108,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        href: docLinks.links.upgrade.upgradingStackOnCloud,
        target: "_blank",
        "data-test-subj": "upgradeSetupDocsLink",
        iconSide: "right",
        iconType: "popout",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }, i18nTexts.upgradeGuideLink)));
    }
  } else {
    callToAction = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      href: docLinks.links.upgrade.upgradingStackOnPrem,
      target: "_blank",
      "data-test-subj": "upgradeSetupDocsLink",
      iconSide: "right",
      iconType: "popout",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 7
      }
    }, i18nTexts.upgradeGuideLink);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }, isCloudEnabled ? i18nTexts.upgradeStepDescriptionForCloud : i18nTexts.upgradeStepDescription)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }), callToAction);
};
const getUpgradeStep = () => {
  return {
    title: i18nTexts.upgradeStepTitle,
    status: 'incomplete',
    'data-test-subj': 'upgradeStep',
    children: /*#__PURE__*/_react.default.createElement(UpgradeStep, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    })
  };
};
exports.getUpgradeStep = getUpgradeStep;