"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDeprecationsPrompt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/upgrade_assistant/public/application/components/shared/no_deprecations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  getEmptyPromptTitle: deprecationType => _i18n.i18n.translate('xpack.upgradeAssistant.noDeprecationsPrompt.description', {
    defaultMessage: 'Your {deprecationType} configuration is up to date',
    values: {
      deprecationType
    }
  }),
  getEmptyPromptDescription: navigateToOverviewPage => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.upgradeAssistant.noDeprecationsPrompt.nextStepsDescription",
    defaultMessage: "Check the {overviewButton} for other Stack deprecations.",
    values: {
      overviewButton: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: navigateToOverviewPage,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 29,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.upgradeAssistant.noDeprecationsPrompt.overviewLinkText', {
        defaultMessage: 'Overview page'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  })
};
const NoDeprecationsPrompt = ({
  deprecationType,
  navigateToOverviewPage
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "check",
    "data-test-subj": "noDeprecationsPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 14
      }
    }, i18nTexts.getEmptyPromptTitle(deprecationType)),
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "upgradeAssistantIssueSummary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 11
      }
    }, i18nTexts.getEmptyPromptDescription(navigateToOverviewPage))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 5
    }
  });
};
exports.NoDeprecationsPrompt = NoDeprecationsPrompt;