"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _capabilities_adapter = require("../lib/adapters/framework/capabilities_adapter");
var _constants = require("../../../common/constants");
var _uptime_app = require("./uptime_app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/app/render_app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function renderApp(core, plugins, startPlugins, appMountParameters, isDev, experimentalFeatures) {
  var _capabilities$uptime$;
  const {
    application: {
      capabilities
    },
    chrome: {
      setBadge,
      setHelpExtension
    },
    docLinks,
    http: {
      basePath
    },
    i18n,
    theme
  } = core;
  const {
    apm,
    infrastructure,
    logs
  } = (0, _capabilities_adapter.getIntegratedAppAvailability)(capabilities, _constants.INTEGRATED_SOLUTIONS);
  const canSave = (_capabilities$uptime$ = capabilities.uptime.save) !== null && _capabilities$uptime$ !== void 0 ? _capabilities$uptime$ : false;
  const darkMode = theme.getTheme().darkMode;
  const props = {
    isDev,
    plugins,
    canSave,
    core,
    i18n,
    startPlugins,
    basePath: basePath.get(),
    darkMode,
    commonlyUsedRanges: core.uiSettings.get(_constants.DEFAULT_TIMEPICKER_QUICK_RANGES),
    isApmAvailable: apm,
    isInfraAvailable: infrastructure,
    isLogsAvailable: logs,
    renderGlobalHelpControls: () => setHelpExtension({
      appName: _i18n.i18n.translate('xpack.uptime.legacyHeader.appName', {
        defaultMessage: 'Uptime'
      }),
      links: [{
        linkType: 'documentation',
        href: `${docLinks.links.observability.monitorUptime}`
      }, {
        linkType: 'discuss',
        href: 'https://discuss.elastic.co/c/uptime'
      }]
    }),
    setBadge,
    appMountParameters,
    setBreadcrumbs: core.chrome.setBreadcrumbs
  };
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_uptime_app.UptimeApp, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 19
    }
  })), appMountParameters.element);
  return () => {
    startPlugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(appMountParameters.element);
  };
}