"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UptimeDataHelper = UptimeDataHelper;
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _api = require("../state/api");
var _kibana_service = require("../state/kibana_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function fetchUptimeOverviewData({
  absoluteTime,
  relativeTime,
  intervalString,
  timeZone
}) {
  const start = new Date(absoluteTime.start).toISOString();
  const end = new Date(absoluteTime.end).toISOString();
  const snapshot = await (0, _api.fetchSnapshotCount)({
    dateRangeStart: start,
    dateRangeEnd: end
  });
  const pings = await (0, _api.fetchPingHistogram)({
    dateStart: start,
    dateEnd: end,
    bucketSize: intervalString,
    timeZone: timeZone !== null && timeZone !== void 0 ? timeZone : _momentTimezone.default.tz.guess()
  });
  const response = {
    appLink: `/app/uptime?dateRangeStart=${relativeTime.start}&dateRangeEnd=${relativeTime.end}`,
    stats: {
      monitors: {
        type: 'number',
        value: snapshot.total
      },
      up: {
        type: 'number',
        value: snapshot.up
      },
      down: {
        type: 'number',
        value: snapshot.down
      }
    },
    series: {
      up: {
        coordinates: pings.histogram.map(p => {
          return {
            x: p.x,
            y: p.upCount || 0
          };
        })
      },
      down: {
        coordinates: pings.histogram.map(p => {
          return {
            x: p.x,
            y: p.downCount || 0
          };
        })
      }
    }
  };
  return response;
}
function UptimeDataHelper(coreStart) {
  _kibana_service.kibanaService.core = coreStart;
  return {
    indexStatus: _api.fetchIndexStatus,
    overviewData: fetchUptimeOverviewData
  };
}