"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificateList = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _cert_status = require("./cert_status");
var _cert_monitors = require("./cert_monitors");
var _translations = _interopRequireWildcard(require("./translations"));
var labels = _translations;
var _fingerprint_col = require("./fingerprint_col");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/certificates/certificates_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CertificateList = ({
  page,
  certificates,
  sort,
  onChange
}) => {
  var _certificates$total, _certificates$certs;
  const onTableChange = newVal => {
    onChange(newVal.page, newVal.sort);
  };
  const pagination = {
    pageIndex: page.index,
    pageSize: page.size,
    totalItemCount: (_certificates$total = certificates === null || certificates === void 0 ? void 0 : certificates.total) !== null && _certificates$total !== void 0 ? _certificates$total : 0,
    pageSizeOptions: [10, 25, 50, 100],
    showPerPageOptions: true
  };
  const columns = [{
    field: 'not_after',
    name: labels.STATUS_COL,
    sortable: true,
    render: (val, item) => /*#__PURE__*/_react.default.createElement(_cert_status.CertStatus, {
      cert: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 44
      }
    })
  }, {
    name: labels.COMMON_NAME_COL,
    field: 'common_name',
    sortable: true
  }, {
    name: labels.MONITORS_COL,
    field: 'monitors',
    render: monitors => /*#__PURE__*/_react.default.createElement(_cert_monitors.CertMonitors, {
      monitors: monitors,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 44
      }
    })
  }, {
    name: labels.ISSUED_BY_COL,
    field: 'issuer',
    sortable: true
  }, {
    name: labels.VALID_UNTIL_COL,
    field: 'not_after',
    sortable: true,
    render: value => (0, _moment.default)(value).format('L LT')
  }, {
    name: labels.AGE_COL,
    field: 'not_before',
    sortable: true,
    render: value => (0, _moment.default)().diff((0, _moment.default)(value), 'days') + ' ' + labels.DAYS
  }, {
    name: labels.FINGERPRINTS_COL,
    field: 'sha256',
    render: (val, item) => /*#__PURE__*/_react.default.createElement(_fingerprint_col.FingerprintCol, {
      cert: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 44
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    loading: certificates.loading,
    columns: columns,
    items: (_certificates$certs = certificates === null || certificates === void 0 ? void 0 : certificates.certs) !== null && _certificates$certs !== void 0 ? _certificates$certs : [],
    pagination: pagination,
    onChange: onTableChange,
    sorting: {
      sort: {
        field: sort.field,
        direction: sort.direction
      }
    },
    noItemsMessage: certificates.loading ? _translations.LOADING_CERTIFICATES : /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "uptimeCertsEmptyMessage",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }, _translations.NO_CERTS_AVAILABLE),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  });
};
exports.CertificateList = CertificateList;