"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DurationLineSeriesList = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _formatting = require("../../../lib/formatting");
var _translations = require("../../../../../common/translations/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/charts/duration_line_series_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DurationLineSeriesList = ({
  monitorType,
  lines
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, lines.map(({
  name,
  line
}) => /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
  curve: _charts.CurveType.CURVE_MONOTONE_X
  // this id is used for the line chart representing the average duration length
  ,
  data: line.map(({
    x,
    y
  }) => [x, y || null]),
  id: `loc-avg-${name}`,
  key: `loc-line-${name}`,
  name: name,
  xAccessor: 0
  // Defaults to multi layer time axis as of Elastic Charts v70
  ,
  xScaleType: _charts.ScaleType.Time,
  yAccessors: [1],
  yScaleType: _charts.ScaleType.Linear,
  fit: _charts.Fit.Linear,
  timeZone: "local",
  tickFormat: d => monitorType === 'browser' ? `${(0, _formatting.microToSec)(d)} ${_translations.SEC_LABEL}` : `${(0, _formatting.microToMilli)(d)} ${_translations.MS_LABEL}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 7
  }
})));
exports.DurationLineSeriesList = DurationLineSeriesList;