"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorTags = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_filter_update = require("../../hooks/use_filter_update");
var _hooks = require("../../hooks");
var _monitor_name_col = require("../overview/monitor_list/columns/monitor_name_col");
var _translations = require("../overview/monitor_list/columns/translations");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/common/monitor_tags.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getTagsFromSummary = summary => {
  let tags = new Set();
  summary.state.summaryPings.forEach(ping => {
    var _ping$tags;
    tags = new Set([...tags, ...((_ping$tags = ping === null || ping === void 0 ? void 0 : ping.tags) !== null && _ping$tags !== void 0 ? _ping$tags : [])]);
  });
  return [...tags];
};
const getTagsFromPing = ping => {
  var _ping$tags2;
  return (_ping$tags2 = ping === null || ping === void 0 ? void 0 : ping.tags) !== null && _ping$tags2 !== void 0 ? _ping$tags2 : [];
};
const getFilterLabel = tag => {
  return _i18n.i18n.translate('xpack.uptime.monitorList.tags.filter', {
    defaultMessage: 'Filter all monitors with tag {tag}',
    values: {
      tag
    }
  });
};
const MonitorTags = ({
  ping,
  summary
}) => {
  var _currFilters$get;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      docLinks
    }
  } = (0, _public.useKibana)();
  const [toDisplay, setToDisplay] = (0, _react.useState)(5);
  let tags;
  if (summary) {
    // summary in case of monitor list
    tags = getTagsFromSummary(summary);
  } else {
    tags = getTagsFromPing(ping);
  }
  const tagsToDisplay = tags.slice(0, toDisplay);
  const {
    absoluteDateRangeStart,
    absoluteDateRangeEnd,
    ...params
  } = (0, _hooks.useGetUrlParams)();
  const currFilters = (0, _monitor_name_col.parseCurrentFilters)(params.filters);
  const [tagFilters, setTagFilters] = (0, _react.useState)((_currFilters$get = currFilters.get('tags')) !== null && _currFilters$get !== void 0 ? _currFilters$get : []);
  const excludedTagFilters = (0, _react.useMemo)(() => {
    var _currExcludedFilters$;
    const currExcludedFilters = (0, _monitor_name_col.parseCurrentFilters)(params.excludedFilters);
    return (_currExcludedFilters$ = currExcludedFilters.get('tags')) !== null && _currExcludedFilters$ !== void 0 ? _currExcludedFilters$ : [];
  }, [params.excludedFilters]);
  (0, _use_filter_update.useFilterUpdate)('tags', tagFilters, excludedTagFilters);
  if (tags.length === 0) {
    return summary ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "syntheticsMonitorTagsSetTagsLink",
      href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.heartbeat.monitorTags,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 7
      }
    }, "Set tags");
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, tagsToDisplay.map(tag =>
  // filtering only makes sense in monitor list, where we have summary
  summary ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    title: getFilterLabel(tag),
    onClick: () => {
      setTagFilters([tag]);
    },
    onClickAriaLabel: getFilterLabel(tag),
    color: "hollow",
    className: "eui-textTruncate",
    style: {
      maxWidth: 120
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 11
    }
  }, tag) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    key: tag,
    color: "hollow",
    className: "eui-textTruncate",
    style: {
      maxWidth: 120
    },
    href: history.createHref({
      pathname: _constants.OVERVIEW_ROUTE,
      search: `filters=[["tags",["${tag}"]]]`
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, tag)), tags.length > toDisplay && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    onClick: () => {
      setToDisplay(tags.length);
    },
    onClickAriaLabel: _translations.EXPAND_TAGS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, "+", tags.length - 5));
};
exports.MonitorTags = MonitorTags;