"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SyntheticsPolicyCreateExtension = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _deprecate_notice_modal = require("./deprecate_notice_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/fleet_package/synthetics_policy_create_extension.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Exports Synthetics-specific package policy instructions
 * for use in the Ingest app create / edit package policy
 */
const SyntheticsPolicyCreateExtension = exports.SyntheticsPolicyCreateExtension = /*#__PURE__*/(0, _react.memo)(({
  newPolicy
}) => {
  (0, _public.useTrackPageview)({
    app: 'fleet',
    path: 'syntheticsCreate'
  });
  (0, _public.useTrackPageview)({
    app: 'fleet',
    path: 'syntheticsCreate',
    delay: 15000
  });
  const {
    application
  } = (0, _public2.useKibana)().services;
  const {
    package: pkg
  } = newPolicy;
  const onCancel = (0, _react.useCallback)(() => {
    application === null || application === void 0 ? void 0 : application.navigateToApp('integrations', {
      path: `/detail/${pkg === null || pkg === void 0 ? void 0 : pkg.name}-${pkg === null || pkg === void 0 ? void 0 : pkg.version}/overview`
    });
  }, [application, pkg === null || pkg === void 0 ? void 0 : pkg.name, pkg === null || pkg === void 0 ? void 0 : pkg.version]);
  return /*#__PURE__*/_react.default.createElement(_deprecate_notice_modal.DeprecateNoticeModal, {
    onCancel: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 12
    }
  });
});
SyntheticsPolicyCreateExtension.displayName = 'SyntheticsPolicyCreateExtension';