"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorPageTitle = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../hooks");
var _selectors = require("../../state/selectors");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/monitor_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const isAutogeneratedId = id => {
  const autoGeneratedId = /^auto-(icmp|http|tcp|browser)-0X[A-F0-9]{16}.*/;
  return autoGeneratedId.test(id);
};

// For monitors with no explicit ID, we display the URL instead of the
// auto-generated ID because it is difficult to derive meaning from a
// generated id like `auto-http-0X8D6082B94BBE3B8A`.
// We may deprecate this behavior in the next major release, because
// the heartbeat config will require an explicit ID.
const getPageTitle = (monitorId, selectedMonitor) => {
  if (isAutogeneratedId(monitorId)) {
    var _selectedMonitor$url;
    return (selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$url = selectedMonitor.url) === null || _selectedMonitor$url === void 0 ? void 0 : _selectedMonitor$url.full) || monitorId;
  }
  return monitorId;
};
const MonitorPageTitle = () => {
  var _selectedMonitor$moni;
  const monitorId = (0, _hooks.useMonitorId)();
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  const nameOrId = (selectedMonitor === null || selectedMonitor === void 0 ? void 0 : (_selectedMonitor$moni = selectedMonitor.monitor) === null || _selectedMonitor$moni === void 0 ? void 0 : _selectedMonitor$moni.name) || getPageTitle(monitorId, selectedMonitor);
  (0, _use_breadcrumbs.useBreadcrumbs)([{
    text: nameOrId
  }]);
  return /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textNoWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 10
    }
  }, nameOrId);
};
exports.MonitorPageTitle = MonitorPageTitle;