"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandRowColumn = void 0;
exports.rowShouldExpand = rowShouldExpand;
exports.toggleDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _expanded_row = require("../expanded_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_list/columns/expand_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const toggleDetails = (ping, expandedRows, setExpandedRows) => {
  // If already expanded, collapse
  if (expandedRows[ping.docId]) {
    delete expandedRows[ping.docId];
    setExpandedRows({
      ...expandedRows
    });
    return;
  }

  // Otherwise expand this row
  setExpandedRows({
    ...expandedRows,
    [ping.docId]: /*#__PURE__*/_react.default.createElement(_expanded_row.PingListExpandedRowComponent, {
      ping: ping,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 19
      }
    })
  });
};
exports.toggleDetails = toggleDetails;
function rowShouldExpand(item) {
  var _item$http$response$b, _item$http, _item$http$response, _item$http$response$b2;
  const errorPresent = !!item.error;
  const httpBodyPresent = (_item$http$response$b = (_item$http = item.http) === null || _item$http === void 0 ? void 0 : (_item$http$response = _item$http.response) === null || _item$http$response === void 0 ? void 0 : (_item$http$response$b2 = _item$http$response.body) === null || _item$http$response$b2 === void 0 ? void 0 : _item$http$response$b2.bytes) !== null && _item$http$response$b !== void 0 ? _item$http$response$b : 0 > 0;
  const isBrowserMonitor = item.monitor.type === 'browser';
  return errorPresent || httpBodyPresent || isBrowserMonitor;
}
const ExpandRowColumn = ({
  item,
  expandedRows,
  setExpandedRows
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "uptimePingListExpandBtn",
    onClick: () => toggleDetails(item, expandedRows, setExpandedRows),
    isDisabled: !rowShouldExpand(item),
    "aria-label": expandedRows[item.docId] ? _i18n.i18n.translate('xpack.uptime.pingList.collapseRow', {
      defaultMessage: 'Collapse'
    }) : _i18n.i18n.translate('xpack.uptime.pingList.expandRow', {
      defaultMessage: 'Expand'
    }),
    iconType: expandedRows[item.docId] ? 'arrowUp' : 'arrowDown',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  });
};
exports.ExpandRowColumn = ExpandRowColumn;