"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PingStatusColumn = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _translations = require("../../../../../../common/translations/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/ping_list/columns/ping_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getPingStatusLabel = (status, ping) => {
  if (ping.monitor.type === _constants.MONITOR_TYPES.BROWSER) {
    return status === 'up' ? _translations.STATUS_COMPLETE_LABEL : _translations.STATUS_FAILED_LABEL;
  }
  return status === 'up' ? _translations.STATUS_UP_LABEL : _translations.STATUS_DOWN_LABEL;
};
const PingStatusColumn = ({
  pingStatus,
  item
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const isAmsterdam = theme.euiTheme.themeName === 'EUI_THEME_AMSTERDAM';
  const dangerBehindText = isAmsterdam ? theme.euiTheme.colors.vis.euiColorVisBehindText9 : theme.euiTheme.colors.vis.euiColorVis6;
  const timeStamp = (0, _moment.default)(item.timestamp);
  let checkedTime = '';
  if ((0, _moment.default)().diff(timeStamp, 'd') > 1) {
    checkedTime = timeStamp.format('ll LTS');
  } else {
    checkedTime = timeStamp.format('LTS');
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `xpack.synthetics.pingList.ping-${item.docId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    className: "eui-textCenter",
    color: pingStatus === _constants.STATUS.UP ? 'success' : dangerBehindText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, getPingStatusLabel(pingStatus, item)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.uptime.pingList.recencyMessage', {
    values: {
      fromNow: checkedTime
    },
    defaultMessage: 'Checked {fromNow}',
    description: 'A string used to inform our users how long ago Heartbeat pinged the selected host.'
  })));
};
exports.PingStatusColumn = PingStatusColumn;