"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorSSLCertificate = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _cert_status_column = require("../../../overview/monitor_list/columns/cert_status_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/status_details/status_bar/ssl_certificate.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorSSLCertificate = ({
  tls
}) => {
  var _tls$server;
  let expiry = null;
  if (tls !== null && tls !== void 0 && (_tls$server = tls.server) !== null && _tls$server !== void 0 && _tls$server.x509) {
    expiry = tls.server.x509;
  }
  if (!expiry) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.monitorStatusBar.sslCertificate.title",
    defaultMessage: "TLS Certificate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
    to: _constants.CERTIFICATES_ROUTE,
    className: "eui-displayInline",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_cert_status_column.CertStatusColumn, {
    expiry: expiry,
    boldStyle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }))));
};
exports.MonitorSSLCertificate = MonitorSSLCertificate;