"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderMonitorType = exports.MonitorStatusBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _translations = require("../../../overview/monitor_list/columns/translations");
var _selectors = require("../../../../state/selectors");
var _enable_alert = require("../../../overview/monitor_list/columns/enable_alert");
var _ssl_certificate = require("./ssl_certificate");
var _translations2 = _interopRequireWildcard(require("../translations"));
var labels = _translations2;
var _status_by_location = require("./status_by_location");
var _use_status_bar = require("./use_status_bar");
var _translations3 = require("../../../../../../common/translations/translations");
var _availability_reporting = require("../availability_reporting/availability_reporting");
var _monitor_redirects = require("./monitor_redirects");
var _monitor_tags = require("../../../common/monitor_tags");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/status_details/status_bar/status_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const renderMonitorType = type => {
  switch (type) {
    case 'http':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.http', {
        defaultMessage: 'HTTP'
      });
    case 'tcp':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.tcp', {
        defaultMessage: 'TCP'
      });
    case 'icmp':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.icmp', {
        defaultMessage: 'ICMP'
      });
    case 'browser':
      return _i18n.i18n.translate('xpack.uptime.monitorDetails.statusBar.pingType.browser', {
        defaultMessage: 'Browser'
      });
    default:
      return '';
  }
};
exports.renderMonitorType = renderMonitorType;
const MonitorStatusBar = () => {
  var _monitorStatus$url$fu, _monitorStatus$url, _monitorStatus$monito, _monitorStatus$monito2, _monitorStatus$monito3, _monitorStatus$monito4, _monitorStatus$monito5;
  const {
    monitorId,
    monitorStatus,
    monitorLocations = {}
  } = (0, _use_status_bar.useStatusBar)();
  const {
    locations,
    up_history: ups,
    down_history: downs
  } = monitorLocations;
  const full = (_monitorStatus$url$fu = monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$url = monitorStatus.url) === null || _monitorStatus$url === void 0 ? void 0 : _monitorStatus$url.full) !== null && _monitorStatus$url$fu !== void 0 ? _monitorStatus$url$fu : '';
  const availability = ups === 0 && downs === 0 || !ups ? 0 : ups / (ups + downs) * 100;
  const selectedMonitor = (0, _reactRedux.useSelector)(_selectors.monitorStatusSelector);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_status_by_location.StatusByLocations, {
    locations: locations !== null && locations !== void 0 ? locations : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    textStyle: "reverse",
    columnWidths: [1, 3],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, _translations2.OverallAvailability), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "uptimeOverallAvailability",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.availabilityLabelText",
    defaultMessage: "{value} %",
    values: {
      value: (0, _availability_reporting.formatAvailabilityValue)(availability)
    },
    description: "A percentage value, like 23.5 %",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, _translations3.URL_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-url",
    className: "eui-textBreakAll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, full ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "syntheticsMonitorStatusBarLink",
    "aria-label": labels.monitorUrlLinkAriaLabel,
    href: full,
    target: "_blank",
    external: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 13
    }
  }, full) : '--'), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, _translations2.MonitorIDLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, monitorId), (monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito = monitorStatus.monitor) === null || _monitorStatus$monito === void 0 ? void 0 : _monitorStatus$monito.type) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    "aria-label": labels.typeAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 13
    }
  }, labels.typeLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "monitor-page-type",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 13
    }
  }, renderMonitorType(monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito2 = monitorStatus.monitor) === null || _monitorStatus$monito2 === void 0 ? void 0 : _monitorStatus$monito2.type))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, _translations3.TAGS_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_monitor_tags.MonitorTags, {
    ping: monitorStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  })), (monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito3 = monitorStatus.monitor) === null || _monitorStatus$monito3 === void 0 ? void 0 : (_monitorStatus$monito4 = _monitorStatus$monito3.project) === null || _monitorStatus$monito4 === void 0 ? void 0 : _monitorStatus$monito4.id) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, _translations3.PROJECT_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, monitorStatus === null || monitorStatus === void 0 ? void 0 : (_monitorStatus$monito5 = monitorStatus.monitor) === null || _monitorStatus$monito5 === void 0 ? void 0 : _monitorStatus$monito5.project.id)), /*#__PURE__*/_react.default.createElement(_ssl_certificate.MonitorSSLCertificate, {
    tls: monitorStatus === null || monitorStatus === void 0 ? void 0 : monitorStatus.tls,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_monitor_redirects.MonitorRedirects, {
    monitorStatus: monitorStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  }, _translations.ENABLE_STATUS_ALERT), selectedMonitor && /*#__PURE__*/_react.default.createElement("dd", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_enable_alert.EnableMonitorAlert, {
    monitorId: monitorId,
    selectedMonitor: selectedMonitor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }))));
};
exports.MonitorStatusBar = MonitorStatusBar;