"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _hooks = require("../../../hooks");
var _selectors = require("../../../state/selectors");
var _monitor = require("../../../state/actions/monitor");
var _ = require(".");
var _contexts = require("../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/status_details/status_details_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MonitorStatusDetails = ({
  monitorId
}) => {
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const {
    dateRangeStart: dateStart,
    dateRangeEnd: dateEnd
  } = (0, _hooks.useGetUrlParams)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const monitorLocations = (0, _reactRedux.useSelector)(state => (0, _selectors.monitorLocationsSelector)(state, monitorId));
  (0, _react.useEffect)(() => {
    dispatch((0, _monitor.getMonitorLocationsAction)({
      dateStart,
      dateEnd,
      monitorId
    }));
  }, [monitorId, dateStart, dateEnd, lastRefresh, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_.MonitorStatusDetailsComponent, {
    monitorLocations: monitorLocations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 10
    }
  });
};
exports.MonitorStatusDetails = MonitorStatusDetails;