"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTooltipResponsiveMaxWidth = exports.WaterfallChartTopContainer = exports.WaterfallChartTooltip = exports.WaterfallChartSidebarWrapper = exports.WaterfallChartSidebarFlexItem = exports.WaterfallChartSidebarContainerInnerPanel = exports.WaterfallChartSidebarContainerFlexGroup = exports.WaterfallChartSidebarContainer = exports.WaterfallChartOuterContainer = exports.WaterfallChartLegendContainer = exports.WaterfallChartFixedTopContainerSidebarCover = exports.WaterfallChartFixedTopContainer = exports.WaterfallChartFixedAxisContainer = exports.WaterfallChartFilterContainer = exports.WaterfallChartChartContainer = exports.WaterfallChartAxisOnlyContainer = exports.SideBarItemHighlighter = exports.RelativeContainer = exports.NetworkRequestsTotalStyle = void 0;
var _eui = require("@elastic/eui");
var _polished = require("polished");
var _common = require("@kbn/kibana-react-plugin/common");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledScrollDiv = _common.euiStyled.div`
  &::-webkit-scrollbar {
    height: ${({
  theme
}) => theme.eui.euiScrollBar};
    width: ${({
  theme
}) => theme.eui.euiScrollBar};
  }
  &::-webkit-scrollbar-thumb {
    background-clip: content-box;
    background-color: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorDarkShade, 0.5)};
    border: ${({
  theme
}) => theme.eui.euiScrollBarCorner} solid transparent;
  }
  &::-webkit-scrollbar-corner,
  &::-webkit-scrollbar-track {
    background-color: transparent;
  }
`;
const WaterfallChartOuterContainer = exports.WaterfallChartOuterContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  height: ${props => props.height ? `${props.height}` : 'auto'};
  overflow-y: ${props => props.height ? 'scroll' : 'visible'};
  overflow-x: hidden;
`;
const WaterfallChartFixedTopContainer = exports.WaterfallChartFixedTopContainer = (0, _common.euiStyled)(StyledScrollDiv)`
  position: sticky;
  top: 0;
  z-index: ${props => props.theme.eui.euiZLevel4};
  overflow-y: scroll;
  overflow-x: hidden;
`;
const WaterfallChartAxisOnlyContainer = exports.WaterfallChartAxisOnlyContainer = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  margin-left: -16px;
`;
const WaterfallChartTopContainer = exports.WaterfallChartTopContainer = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
`;
const WaterfallChartFixedTopContainerSidebarCover = exports.WaterfallChartFixedTopContainerSidebarCover = (0, _common.euiStyled)(_eui.EuiPanel)`
  height: 100%;
  border-radius: 0 !important;
  border: none;
`; // NOTE: border-radius !important is here as the "border" prop isn't working

const WaterfallChartFilterContainer = exports.WaterfallChartFilterContainer = _common.euiStyled.div`
  && {
    padding: 16px;
    z-index: ${props => props.theme.eui.euiZLevel5};
    border-bottom: 0.3px solid ${props => props.theme.eui.euiColorLightShade};
  }
`; // NOTE: border-radius !important is here as the "border" prop isn't working

const WaterfallChartFixedAxisContainer = exports.WaterfallChartFixedAxisContainer = _common.euiStyled.div`
  height: ${_constants.FIXED_AXIS_HEIGHT}px;
  z-index: ${props => props.theme.eui.euiZLevel4};
  height: 100%;
  &&& {
    .echAnnotation__icon {
      top: 8px;
    }
  }
`;
const WaterfallChartSidebarWrapper = exports.WaterfallChartSidebarWrapper = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  z-index: ${props => props.theme.eui.euiZLevel5};
  min-width: 0;
`; // NOTE: min-width: 0 ensures flexbox and no-wrap children can co-exist

const WaterfallChartSidebarContainer = exports.WaterfallChartSidebarContainer = _common.euiStyled.div`
  height: ${props => `${props.height}px`};
  overflow-y: hidden;
  overflow-x: hidden;
`;
const WaterfallChartSidebarContainerInnerPanel = exports.WaterfallChartSidebarContainerInnerPanel = (0, _common.euiStyled)(_eui.EuiPanel)`
  border: 0;
  height: 100%;
`;
const WaterfallChartSidebarContainerFlexGroup = exports.WaterfallChartSidebarContainerFlexGroup = (0, _common.euiStyled)(_eui.EuiFlexGroup)`
  height: 100%;
`;

// Ensures flex items honour no-wrap of children, rather than trying to extend to the full width of children.
const WaterfallChartSidebarFlexItem = exports.WaterfallChartSidebarFlexItem = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  min-width: 0;
  padding-right: ${props => props.theme.eui.euiSizeS};
  justify-content: space-around;
`;
const SideBarItemHighlighter = exports.SideBarItemHighlighter = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  opacity: ${props => props.isHighlighted ? 1 : 0.4};
  height: 100%;
  .euiButtonEmpty {
    height: ${_constants.FIXED_AXIS_HEIGHT}px;
    font-size:${({
  theme
}) => theme.eui.euiFontSizeM};
  }
`;
const WaterfallChartChartContainer = exports.WaterfallChartChartContainer = _common.euiStyled.div`
  width: 100%;
  height: ${props => `${props.height + _constants.FIXED_AXIS_HEIGHT + 4}px`};
  margin-top: -${_constants.FIXED_AXIS_HEIGHT + 4}px;
  z-index: ${props => Math.round(props.theme.eui.euiZLevel3 / (props.chartIndex + 1))};
`;
const WaterfallChartLegendContainer = exports.WaterfallChartLegendContainer = _common.euiStyled.div`
  position: sticky;
  bottom: 0;
  z-index: ${props => props.theme.eui.euiZLevel4};
  background-color: ${props => props.theme.eui.euiColorLightestShade};
  padding: ${props => props.theme.eui.euiSizeXS};
  font-size: ${props => props.theme.eui.euiFontSizeXS};
  box-shadow: 0px -1px 4px 0px ${props => props.theme.eui.euiColorLightShade};
`; // NOTE: EuiShadowColor is a little too dark to work with the background-color

const WaterfallTooltipResponsiveMaxWidth = exports.WaterfallTooltipResponsiveMaxWidth = _common.euiStyled.div`
  margin-top: 16px;
  max-width: 90vw;
`;
const WaterfallChartTooltip = exports.WaterfallChartTooltip = (0, _common.euiStyled)(WaterfallTooltipResponsiveMaxWidth)`
  background-color: ${props => props.theme.eui.euiColorDarkestShade};
  border-radius: ${props => props.theme.eui.euiBorderRadius};
  color: ${props => props.theme.eui.euiColorLightestShade};
  padding: ${props => props.theme.eui.euiSizeS};
  .euiToolTip__arrow {
    background-color: ${props => props.theme.eui.euiColorDarkestShade};
  }
`;
const NetworkRequestsTotalStyle = exports.NetworkRequestsTotalStyle = (0, _common.euiStyled)(_eui.EuiText)`
  line-height: 28px;
  padding: 0 ${props => props.theme.eui.euiSizeM};
  border-bottom: 0.3px solid ${props => props.theme.eui.euiColorLightShade};
  z-index: ${props => props.theme.eui.euiZLevel5};
`;
const RelativeContainer = exports.RelativeContainer = _common.euiStyled.div`
    position: relative;
`;