"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallChartFixedAxis = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _i18n = require("@kbn/i18n");
var _chartsTheme = require("@kbn/charts-theme");
var _styles = require("./styles");
var _waterfall_markers = require("./waterfall_markers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/waterfall_chart_fixed_axis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WaterfallChartFixedAxis = ({
  tickFormat,
  domain,
  barStyleAccessor
}) => {
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  return /*#__PURE__*/_react.default.createElement(_styles.WaterfallChartFixedAxisContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    className: "axis-only-chart",
    "data-test-subj": "axisOnlyChart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    showLegend: false,
    rotation: 90,
    baseTheme: chartBaseTheme,
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "time",
    position: _charts.Position.Top,
    tickFormat: tickFormat,
    domain: domain,
    gridLine: {
      visible: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    "aria-hidden": true,
    id: "waterfallItems",
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    y0Accessors: ['y0'],
    styleAccessor: barStyleAccessor,
    data: [{
      x: 0,
      y0: 0,
      y1: 1
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_waterfall_markers.WaterfallChartMarkers, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  })));
};
exports.WaterfallChartFixedAxis = WaterfallChartFixedAxis;