"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallMarkerIcon = WaterfallMarkerIcon;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _waterfall_marker_trend = require("./waterfall_marker_trend");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/waterfall_marker_icon.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function WaterfallMarkerIcon({
  field,
  label
}) {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  if (!field) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.markers.noFieldIcon.label', {
        defaultMessage: 'An icon indicating that this marker has no field associated with it'
      }),
      type: "dot",
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 18,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    anchorPosition: "downLeft",
    panelStyle: {
      paddingBottom: 0,
      paddingLeft: 4
    },
    zIndex: 100,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "observabilitySolutionWaterfallMarkerIconButton",
      "aria-label": _i18n.i18n.translate('xpack.uptime.synthetics.markers.openEmbeddableButton.label', {
        defaultMessage: 'Use this icon button to show metrics for this annotation marker.'
      }),
      iconType: "dot",
      iconSize: "l",
      color: "text",
      onClick: () => setIsOpen(prevState => !prevState),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_waterfall_marker_trend.WaterfallMarkerTrend, {
    title: label,
    field: field,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
}