"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaterfallTooltipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _waterfall_chart = require("../context/waterfall_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/monitor/synthetics/waterfall/components/waterfall_tooltip_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StyledText = (0, _common.euiStyled)(_eui.EuiText)`
  font-weight: bold;
`;
const StyledHorizontalRule = (0, _common.euiStyled)(_eui.EuiHorizontalRule)`
  background-color: ${props => props.theme.eui.euiColorDarkShade};
`;
const WaterfallTooltipContent = ({
  text,
  url
}) => {
  const {
    data,
    renderTooltipItem,
    sidebarItems
  } = (0, _waterfall_chart.useWaterfallContext)();
  const tooltipMetrics = data.filter(datum => {
    var _sidebarItems$find;
    return datum.x === (sidebarItems === null || sidebarItems === void 0 ? void 0 : (_sidebarItems$find = sidebarItems.find(sidebarItem => sidebarItem.url === url)) === null || _sidebarItems$find === void 0 ? void 0 : _sidebarItems$find.index) && datum.config.tooltipProps && datum.config.showTooltip;
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(StyledText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, text), /*#__PURE__*/_react.default.createElement(StyledHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, tooltipMetrics.map((item, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }, renderTooltipItem(item.config.tooltipProps)))));
};
exports.WaterfallTooltipContent = WaterfallTooltipContent;