"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleAlertFieldNumberChange = exports.AlertFieldNumber = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/alert_field_number.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const handleAlertFieldNumberChange = (e, isInvalid, setIsInvalid, setFieldValue) => {
  const num = parseInt(e.target.value, 10);
  if (isNaN(num) || num < 1) {
    setIsInvalid(true);
  } else {
    if (isInvalid) setIsInvalid(false);
    setFieldValue(num);
  }
};
exports.handleAlertFieldNumberChange = handleAlertFieldNumberChange;
const AlertFieldNumber = ({
  'aria-label': ariaLabel,
  'data-test-subj': dataTestSubj,
  disabled,
  fieldValue,
  setFieldValue
}) => {
  const [isInvalid, setIsInvalid] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "aria-label": ariaLabel,
    compressed: true,
    "data-test-subj": dataTestSubj,
    min: 1,
    onChange: e => handleAlertFieldNumberChange(e, isInvalid, setIsInvalid, setFieldValue),
    disabled: disabled,
    value: fieldValue,
    isInvalid: isInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
};
exports.AlertFieldNumber = AlertFieldNumber;