"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusExpressionSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _down_number_select = require("./down_number_select");
var _time_expression_select = require("./time_expression_select");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/monitor_expressions/status_expression_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StatusExpressionSelect = ({
  ruleParams,
  hasFilters,
  setRuleParams
}) => {
  var _ruleParams$shouldChe;
  const [isEnabled, setIsEnabled] = (0, _react.useState)((_ruleParams$shouldChe = ruleParams.shouldCheckStatus) !== null && _ruleParams$shouldChe !== void 0 ? _ruleParams$shouldChe : true);
  (0, _react.useEffect)(() => {
    setRuleParams('shouldCheckStatus', isEnabled);
  }, [isEnabled, setRuleParams]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "statusEnabled",
    label: _translations.statusExpLabels.ENABLED_CHECKBOX,
    checked: isEnabled,
    onChange: () => setIsEnabled(!isEnabled),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_down_number_select.DownNoExpressionSelect, {
    defaultNumTimes: ruleParams.numTimes,
    hasFilters: hasFilters,
    isEnabled: isEnabled,
    setRuleParams: setRuleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_time_expression_select.TimeExpressionSelect, {
    defaultTimerangeUnit: ruleParams.timerangeUnit,
    defaultTimerangeCount: ruleParams.timerangeCount,
    isEnabled: isEnabled,
    setRuleParams: setRuleParams,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  })));
};
exports.StatusExpressionSelect = StatusExpressionSelect;