"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddFilterButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("../translations"));
var _uptime_data_view_context = require("../../../../contexts/uptime_data_view_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/alerts/monitor_status_alert/add_filter_btn.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddFilterButton = ({
  newFilters,
  onNewFilter,
  alertFilters
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const getSelectedItems = fieldName => {
    var _alertFilters$fieldNa;
    return (_alertFilters$fieldNa = alertFilters === null || alertFilters === void 0 ? void 0 : alertFilters[fieldName]) !== null && _alertFilters$fieldNa !== void 0 ? _alertFilters$fieldNa : [];
  };
  const dataView = (0, _uptime_data_view_context.useUptimeDataView)();
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const items = [];
  const allFilters = [{
    id: 'observer.geo.name',
    label: labels.LOCATION
  }, {
    id: 'tags',
    label: labels.TAG
  }, {
    id: 'url.port',
    label: labels.PORT
  }, {
    id: 'monitor.type',
    label: labels.TYPE
  }];
  allFilters.forEach(filter => {
    var _getSelectedItems;
    if (((_getSelectedItems = getSelectedItems(filter.id)) === null || _getSelectedItems === void 0 ? void 0 : _getSelectedItems.length) === 0 && !newFilters.includes(filter.id)) {
      items.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        "data-test-subj": 'uptimeAlertAddFilter.' + filter.id,
        key: filter.id,
        onClick: () => {
          closePopover();
          onNewFilter(filter.id);
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 9
        }
      }, filter.label));
    }
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "uptimeCreateAlertAddFilter",
    disabled: items.length === 0 || !dataView,
    iconType: "plusInCircleFilled",
    onClick: onButtonClick,
    size: "s",
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, labels.ADD_FILTER);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "singlePanel",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 7
    }
  }));
};
exports.AddFilterButton = AddFilterButton;