"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableMonitorAlert = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _selectors = require("../../../../state/selectors");
var _alerts = require("../../../../state/alerts/alerts");
var _constants = require("../../../../../../common/constants");
var _define_connectors = require("./define_connectors");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/columns/enable_alert.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EnableMonitorAlert = ({
  monitorId,
  selectedMonitor
}) => {
  var _alerts$data, _hasAlert, _settings$defaultConn2;
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    settings
  } = (0, _reactRedux.useSelector)(_selectors.selectDynamicSettings);
  const isMonitorPage = (0, _reactRouterDom.useRouteMatch)(_constants.MONITOR_ROUTE);
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    data: actionConnectors
  } = (0, _reactRedux.useSelector)(_alerts.connectorsSelector);
  const {
    data: alerts,
    loading: alertsLoading
  } = (0, _reactRedux.useSelector)(_alerts.alertsSelector);
  const {
    data: deletedAlertId
  } = (0, _reactRedux.useSelector)(_alerts.isAlertDeletedSelector);
  const {
    data: newAlert,
    error: newAlertError
  } = (0, _reactRedux.useSelector)(_alerts.newAlertSelector);
  const isNewAlert = newAlert === null || newAlert === void 0 ? void 0 : newAlert.params.search.includes(monitorId);
  let hasAlert = ((_alerts$data = alerts === null || alerts === void 0 ? void 0 : alerts.data) !== null && _alerts$data !== void 0 ? _alerts$data : []).find(alert => alert.params.search.includes(monitorId));
  if (isNewAlert) {
    // if it's newly created alert, we assign that quickly without waiting for find alert result
    hasAlert = newAlert;
  }
  if (deletedAlertId === ((_hasAlert = hasAlert) === null || _hasAlert === void 0 ? void 0 : _hasAlert.id)) {
    // if it just got deleted, we assign that quickly without waiting for find alert result
    hasAlert = undefined;
  }
  const defaultActions = (actionConnectors !== null && actionConnectors !== void 0 ? actionConnectors : []).filter(act => {
    var _settings$defaultConn;
    return settings === null || settings === void 0 ? void 0 : (_settings$defaultConn = settings.defaultConnectors) === null || _settings$defaultConn === void 0 ? void 0 : _settings$defaultConn.includes(act.id);
  });
  const enableAlert = () => {
    dispatch(_alerts.createAlertAction.get({
      defaultActions,
      monitorId,
      selectedMonitor,
      defaultEmail: settings === null || settings === void 0 ? void 0 : settings.defaultEmail
    }));
    setIsLoading(true);
  };
  const disableAlert = () => {
    if (hasAlert) {
      dispatch(_alerts.deleteAlertAction.get({
        alertId: hasAlert.id
      }));
      setIsLoading(true);
    }
  };
  (0, _react.useEffect)(() => {
    setIsLoading(false);
  }, [hasAlert, deletedAlertId, newAlertError]);
  const hasDefaultConnectors = ((_settings$defaultConn2 = settings === null || settings === void 0 ? void 0 : settings.defaultConnectors) !== null && _settings$defaultConn2 !== void 0 ? _settings$defaultConn2 : []).length > 0;
  const showSpinner = isLoading || alertsLoading && !alerts;
  const onAlertClick = () => {
    if (hasAlert) {
      disableAlert();
    } else {
      enableAlert();
    }
  };
  const btnLabel = hasAlert ? _translations.DISABLE_STATUS_ALERT : _translations.ENABLE_STATUS_ALERT;
  return hasDefaultConnectors || hasAlert ? /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-displayInlineBlock",
    style: {
      marginRight: 10
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: btnLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    id: 'enableDisableAlertSwitch',
    compressed: !isMonitorPage,
    disabled: showSpinner,
    label: btnLabel,
    showLabel: false,
    "aria-label": btnLabel,
    onChange: onAlertClick,
    checked: !!hasAlert,
    "data-test-subj": hasAlert ? 'uptimeDisableSimpleDownAlert' + monitorId : 'uptimeEnableSimpleDownAlert' + monitorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }), ' ', showSpinner && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    className: "eui-alignMiddle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 27
    }
  })))) : /*#__PURE__*/_react.default.createElement(_define_connectors.DefineAlertConnectors, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 5
    }
  });
};
exports.EnableMonitorAlert = EnableMonitorAlert;