"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../../common/constants");
var _monitor_status_column = require("./monitor_status_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/columns/status_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatusBadge = ({
  status,
  summaryError
}) => {
  const theme = (0, _eui.useEuiTheme)();
  const isAmsterdam = theme.euiTheme.themeName === 'EUI_THEME_AMSTERDAM';
  const dangerBehindText = isAmsterdam ? theme.euiTheme.colors.vis.euiColorVisBehindText9 : theme.euiTheme.colors.vis.euiColorVis6;
  if (status === _constants.STATUS.UP) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      className: "eui-textCenter",
      color: 'success',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 7
      }
    }, (0, _monitor_status_column.getHealthMessage)(status));
  }
  const errorMessage = summaryError === null || summaryError === void 0 ? void 0 : summaryError.message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: errorMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    tabIndex: 0,
    className: "eui-textCenter",
    color: dangerBehindText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, (0, _monitor_status_column.getHealthMessage)(status)));
};
exports.StatusBadge = StatusBadge;