"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterStatusButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/filter_status_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FilterStatusButton = ({
  content,
  dataTestSubj,
  isDisabled,
  isActive,
  value,
  withNext
}) => {
  const [getUrlParams, setUrlParams] = (0, _hooks.useUrlParams)();
  const {
    statusFilter: urlValue
  } = getUrlParams();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": dataTestSubj,
    isToggle: true,
    isSelected: isActive,
    hasActiveFilters: isActive,
    isDisabled: isDisabled,
    onClick: () => {
      const nextFilter = {
        statusFilter: urlValue === value ? '' : value,
        pagination: ''
      };
      setUrlParams(nextFilter);
    },
    withNext: withNext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, content);
};
exports.FilterStatusButton = FilterStatusButton;