"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractSummaryValues = exports.IntegrationGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-shared-plugin/common");
var _integration_link = require("./integration_link");
var _helper = require("../../../../../lib/helper");
var _contexts = require("../../../../../contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_drawer/actions_popover/integration_group.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const extractSummaryValues = summary => {
  var _summary$state$url$do, _summary$state$url, _summary$state$summar, _firstCheck$kubernete, _firstCheck$kubernete2, _firstCheck$kubernete3, _firstCheck$container, _firstCheck$container2, _firstCheck$monitor$i;
  const domain = (_summary$state$url$do = (_summary$state$url = summary.state.url) === null || _summary$state$url === void 0 ? void 0 : _summary$state$url.domain) !== null && _summary$state$url$do !== void 0 ? _summary$state$url$do : '';
  const firstCheck = (_summary$state$summar = summary.state.summaryPings) === null || _summary$state$summar === void 0 ? void 0 : _summary$state$summar[0];
  const podUid = (_firstCheck$kubernete = firstCheck === null || firstCheck === void 0 ? void 0 : (_firstCheck$kubernete2 = firstCheck.kubernetes) === null || _firstCheck$kubernete2 === void 0 ? void 0 : (_firstCheck$kubernete3 = _firstCheck$kubernete2.pod) === null || _firstCheck$kubernete3 === void 0 ? void 0 : _firstCheck$kubernete3.uid) !== null && _firstCheck$kubernete !== void 0 ? _firstCheck$kubernete : undefined;
  const containerId = (_firstCheck$container = firstCheck === null || firstCheck === void 0 ? void 0 : (_firstCheck$container2 = firstCheck.container) === null || _firstCheck$container2 === void 0 ? void 0 : _firstCheck$container2.id) !== null && _firstCheck$container !== void 0 ? _firstCheck$container : undefined;
  const ip = (_firstCheck$monitor$i = firstCheck === null || firstCheck === void 0 ? void 0 : firstCheck.monitor.ip) !== null && _firstCheck$monitor$i !== void 0 ? _firstCheck$monitor$i : undefined;
  return {
    domain,
    podUid,
    containerId,
    ip
  };
};
exports.extractSummaryValues = extractSummaryValues;
const IntegrationGroup = ({
  summary
}) => {
  var _services$share;
  const {
    basePath,
    dateRangeStart,
    dateRangeEnd,
    isApmAvailable,
    isInfraAvailable,
    isLogsAvailable
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const {
    domain,
    podUid,
    containerId,
    ip
  } = extractSummaryValues(summary);
  const {
    services
  } = (0, _public.useKibana)();
  const assetDetailsLocator = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
  return isApmAvailable || isInfraAvailable || isLogsAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  }, isApmAvailable ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.apmIntegrationAction.description', {
      defaultMessage: 'Search APM for this monitor',
      description: 'This value is shown to users when they hover over an icon that will take them to the APM app.'
    }),
    href: (0, _helper.getLegacyApmHref)(summary, basePath, dateRangeStart, dateRangeEnd),
    iconType: "apmApp",
    message: _i18n.i18n.translate('xpack.uptime.apmIntegrationAction.text', {
      defaultMessage: 'Show APM Data',
      description: 'A message explaining that when the user clicks the associated link, it will navigate to the APM app'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.observabilityIntegrationsColumn.apmIntegrationLink.tooltip', {
      defaultMessage: 'Click here to check APM for the domain "{domain}" or explicitly defined "service name".',
      description: 'A messsage shown in a tooltip explaining that the nested anchor tag will navigate to the APM app and search for the given URL domain or explicitly defined service name.',
      values: {
        domain
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  })) : null, isInfraAvailable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.ip.ariaLabel', {
      defaultMessage: `Check Infrastructure UI for this montor's ip address`,
      description: 'This value is shown as the aria label value for screen readers.'
    }),
    href: (0, _helper.getInfraIpHref)(summary, basePath),
    iconType: "metricsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.ip.message', {
      defaultMessage: 'Show host metrics',
      description: `A message explaining that this link will take the user to the Infrastructure UI, filtered for this monitor's IP Address`
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.ip.tooltip', {
      defaultMessage: 'Check Infrastructure UI for the IP "{ip}"',
      values: {
        ip: Array.isArray(ip) ? ip[0] : ip
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.kubernetes.description', {
      defaultMessage: `Check Infrastructure UI for this monitor's pod UID`,
      description: 'This value is shown as the aria label value for screen readers.'
    }),
    href: (0, _helper.getInfraKubernetesHref)(summary, assetDetailsLocator),
    iconType: "metricsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.kubernetes.message', {
      defaultMessage: 'Show pod metrics',
      description: 'A message explaining that this link will take the user to the Infrastructure UI filtered for the monitor Pod UID.'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.kubernetes.tooltip', {
      defaultMessage: 'Check Infrastructure UI for pod UID "{podUid}".',
      values: {
        podUid
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.docker.description', {
      defaultMessage: `Check Infrastructure UI for this monitor's container ID`
    }),
    href: (0, _helper.getInfraContainerHref)(summary, assetDetailsLocator),
    iconType: "metricsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.container.message', {
      defaultMessage: 'Show container metrics'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.infraIntegrationAction.docker.tooltip', {
      defaultMessage: 'Check Infrastructure UI for container ID "{containerId}"',
      values: {
        containerId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 13
    }
  }))) : null, isLogsAvailable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.ip.description', {
      defaultMessage: `Check Logging UI for this monitor's ip address`,
      description: 'This value is shown as the aria label for screen readers.'
    }),
    href: (0, _helper.getLoggingIpHref)(summary, basePath),
    iconType: "logsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.ip.message', {
      defaultMessage: 'Show host logs',
      description: `A message explaining that this link will take the user to the Infrastructure UI filtered for the monitor's IP Address`
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.ip.tooltip', {
      defaultMessage: 'Check Logging UI for the IP "{ip}"',
      values: {
        ip: Array.isArray(ip) ? ip[0] : ip
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.ariaLabel', {
      defaultMessage: 'Show pod logs'
    }),
    href: (0, _helper.getLoggingKubernetesHref)(summary, basePath),
    iconType: "logsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.message', {
      defaultMessage: 'Show pod logs'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.kubernetes.tooltip', {
      defaultMessage: 'Check for logs for pod UID "{podUid}"',
      values: {
        podUid
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_link.IntegrationLink, {
    ariaLabel: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.container.id', {
      defaultMessage: 'Show container logs'
    }),
    href: (0, _helper.getLoggingContainerHref)(summary, basePath),
    iconType: "logsApp",
    message: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.container.message', {
      defaultMessage: 'Show container logs'
    }),
    tooltipContent: _i18n.i18n.translate('xpack.uptime.monitorList.loggingIntegrationAction.container.tooltip', {
      defaultMessage: 'Check Logging UI for container ID "{containerId}"',
      values: {
        containerId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }))) : null) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "No integrated applications available",
    description: "This message is shown when no applications that Uptime links to are enabled in the current space",
    id: "xpack.uptime.monitorList.integrationGroup.emptyMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 5
    }
  });
};
exports.IntegrationGroup = IntegrationGroup;