"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _monitor_status_column = require("../columns/monitor_status_column");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/monitor_list_drawer/monitor_status_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MonitorStatusRow = ({
  locationNames,
  status
}) => {
  const color = status === _constants.STATUS.UP ? 'success' : 'danger';
  let checkListArray = [...locationNames];
  // If un-named location exists, move it to end
  if (locationNames.has(_constants.UNNAMED_LOCATION)) {
    checkListArray = checkListArray.filter(item => item !== _constants.UNNAMED_LOCATION);
    checkListArray.push(_constants.UNNAMED_LOCATION);
  }
  const locations = checkListArray.join(', ');
  return /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: color,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, (0, _monitor_status_column.getHealthMessage)(status)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("span", {
    "aria-label": _i18n.i18n.translate('xpack.uptime.monitorList.drawer.statusRowLocationList', {
      defaultMessage: 'A list of locations with "{status}" status when last checked.',
      values: {
        status
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, locations || '--'), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }));
};
exports.MonitorStatusRow = MonitorStatusRow;