"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverviewPageLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/overview_page_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverviewPageLinkButtonIcon = (0, _styledComponents.default)(_eui.EuiButtonIcon)`
  margin-top: 12px;
`;
const OverviewPageLink = ({
  dataTestSubj,
  direction,
  pagination
}) => {
  const [, updateUrlParams] = (0, _hooks.useUrlParams)();
  const icon = direction === 'prev' ? 'arrowLeft' : 'arrowRight';
  const ariaLabel = direction === 'next' ? _i18n.i18n.translate('xpack.uptime.overviewPageLink.next.ariaLabel', {
    defaultMessage: 'Next page of results'
  }) : _i18n.i18n.translate('xpack.uptime.overviewPageLink.prev.ariaLabel', {
    defaultMessage: 'Prev page of results'
  });
  const disableLinkLabel = _i18n.i18n.translate('xpack.uptime.overviewPageLink.disabled.ariaLabel', {
    defaultMessage: 'A disabled pagination button indicating that there cannot be any further navigation in the monitors list.'
  });
  return /*#__PURE__*/_react.default.createElement(OverviewPageLinkButtonIcon, {
    color: "text",
    onClick: () => {
      updateUrlParams({
        pagination
      });
    },
    "data-test-subj": dataTestSubj,
    iconType: icon,
    "aria-label": !pagination ? disableLinkLabel : ariaLabel,
    isDisabled: !pagination,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.OverviewPageLink = OverviewPageLink;