"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _filter_status_button = require("./filter_status_button");
var _hooks = require("../../../hooks");
var _translations = require("../../../../../common/translations/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/monitor_list/status_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatusFilter = () => {
  const {
    statusFilter
  } = (0, _hooks.useGetUrlParams)();

  // Empty string for all filter button value, since we dont store it in url, so keeping it in sync
  const ALL = '';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _i18n.i18n.translate('xpack.uptime.filterBar.filterAllLabel', {
      defaultMessage: 'All'
    }),
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusAll",
    value: ALL,
    withNext: true,
    isActive: statusFilter === '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_UP_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusUp",
    value: "up",
    withNext: true,
    isActive: statusFilter === 'up',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_filter_status_button.FilterStatusButton, {
    content: _translations.STATUS_DOWN_LABEL,
    dataTestSubj: "xpack.synthetics.filterBar.filterStatusDown",
    value: "down",
    withNext: false,
    isActive: statusFilter === 'down',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
exports.StatusFilter = StatusFilter;