"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isValidKuery = exports.QueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_query_bar = require("./use_query_bar");
var _translations = require("./translations");
var _hooks = require("../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/overview/query_bar/query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SYNTAX_STORAGE = 'uptime:queryBarSyntax';
const isValidKuery = query => {
  if (query === '') {
    return true;
  }
  const listOfOperators = [':', '>=', '=>', '>', '<'];
  for (let i = 0; i < listOfOperators.length; i++) {
    const operator = listOfOperators[i];
    const qParts = query.trim().split(operator);
    if (query.includes(operator) && qParts.length > 1 && qParts[1]) {
      return true;
    }
  }
  return false;
};
exports.isValidKuery = isValidKuery;
const QueryBar = () => {
  const {
    search: urlValue
  } = (0, _hooks.useGetUrlParams)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    appName,
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = services;
  const {
    query,
    setQuery,
    submitImmediately
  } = (0, _use_query_bar.useQueryBar)();
  const dataView = (0, _hooks.useUptimeDataView)();
  const [inputVal, setInputVal] = (0, _react.useState)(query.query);
  const isInValid = () => {
    if (query.language === _use_query_bar.SyntaxType.text) {
      return false;
    }
    return (inputVal === null || inputVal === void 0 ? void 0 : inputVal.trim()) !== (urlValue === null || urlValue === void 0 ? void 0 : urlValue.trim());
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      flexBasis: 485
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
    indexPatterns: dataView ? [dataView] : [],
    nonKqlMode: "text",
    iconType: "search",
    isClearable: true,
    onChange: queryN => {
      if ((queryN === null || queryN === void 0 ? void 0 : queryN.language) === _use_query_bar.SyntaxType.text) {
        setQuery({
          query: queryN.query,
          language: queryN.language
        });
      }
      if ((queryN === null || queryN === void 0 ? void 0 : queryN.language) === _use_query_bar.SyntaxType.kuery && isValidKuery(queryN === null || queryN === void 0 ? void 0 : queryN.query)) {
        // we want to submit when user clears or paste a complete kuery
        setQuery({
          query: queryN.query,
          language: queryN.language
        });
      }
      setInputVal(queryN === null || queryN === void 0 ? void 0 : queryN.query);
    },
    onSubmit: queryN => {
      if (queryN) setQuery({
        query: queryN.query,
        language: queryN.language
      });
      submitImmediately();
    },
    query: {
      ...query,
      query: inputVal
    },
    "aria-label": _i18n.i18n.translate('xpack.uptime.filterBar.ariaLabel', {
      defaultMessage: 'Input filter criteria for the overview page'
    }),
    "data-test-subj": "uptimeSearchBarInput",
    autoSubmit: true,
    storageKey: SYNTAX_STORAGE,
    placeholder: query.language === _use_query_bar.SyntaxType.kuery ? _translations.KQL_PLACE_HOLDER : _translations.SIMPLE_SEARCH_PLACEHOLDER,
    isInvalid: isInValid(),
    appName: appName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
};
exports.QueryBar = QueryBar;