"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultEmail = DefaultEmail;
exports.validateEmail = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _alerts = require("../../state/alerts/alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/settings/default_email.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function DefaultEmail({
  errors,
  value,
  isLoading,
  isDisabled,
  onChange,
  connectors
}) {
  var _value$to, _value$cc, _value$bcc;
  const {
    actionTypeRegistry
  } = (0, _public.useKibana)().services.triggersActionsUi;
  const {
    data = []
  } = (0, _reactRedux.useSelector)(_alerts.connectorsSelector);
  if (!(data !== null && data !== void 0 && data.find(connector => (connectors === null || connectors === void 0 ? void 0 : connectors.includes(connector.id)) && connector.actionTypeId === '.email'))) {
    return null;
  }
  const emailActionType = actionTypeRegistry.get('.email');
  const ActionParams = emailActionType.actionParamsFields;
  const onEmailChange = (key, val) => {
    onChange({
      defaultEmail: {
        ...value,
        [key]: val
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.alertConnectors.defaultEmail",
      defaultMessage: "Default email",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.uptime.sourceConfiguration.defaultConnectors.description.defaultEmail",
      defaultMessage: "Email settings required for selected email alert connectors.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(ActionParams, {
    actionParams: {
      to: (_value$to = value === null || value === void 0 ? void 0 : value.to) !== null && _value$to !== void 0 ? _value$to : [],
      cc: (_value$cc = value === null || value === void 0 ? void 0 : value.cc) !== null && _value$cc !== void 0 ? _value$cc : [],
      bcc: (_value$bcc = value === null || value === void 0 ? void 0 : value.bcc) !== null && _value$bcc !== void 0 ? _value$bcc : []
    },
    errors: errors !== null && errors !== void 0 ? errors : {},
    editAction: (key, val, index) => onEmailChange(key, val),
    showEmailSubjectAndMessage: false,
    index: 1,
    isLoading: isLoading,
    isDisabled: isDisabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }));
}
const validateEmail = email => {
  return String(email).toLowerCase().match(/^(([^<>()[\]\\.,;:\s@"]+(\.[^<>()[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/);
};
exports.validateEmail = validateEmail;