"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicesForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/settings/indices_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IndicesForm = ({
  onChange,
  loading,
  formFields,
  fieldErrors,
  isDisabled
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 29,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement("h3", {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.uptime.sourceConfiguration.indicesSectionTitle",
  defaultMessage: "Indices",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 31,
    columnNumber: 9
  }
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 37,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
  title: /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesTitle",
    defaultMessage: "Uptime indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  })),
  description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesDescription",
    defaultMessage: "Index pattern for matching indices that contain Heartbeat data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 38,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
  describedByIds: ['heartbeatIndices'],
  error: fieldErrors === null || fieldErrors === void 0 ? void 0 : fieldErrors.heartbeatIndices,
  fullWidth: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesDefaultValue",
    defaultMessage: "The default value is {defaultValue}",
    values: {
      defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 29
        }
      }, _constants.DYNAMIC_SETTINGS_DEFAULTS.heartbeatIndices)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }),
  isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.heartbeatIndices),
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.heartbeatIndicesLabel",
    defaultMessage: "Heartbeat indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
  isInvalid: !!(fieldErrors !== null && fieldErrors !== void 0 && fieldErrors.heartbeatIndices),
  "data-test-subj": `heartbeat-indices-input-${loading ? 'loading' : 'loaded'}`,
  fullWidth: true,
  disabled: isDisabled,
  isLoading: loading,
  value: (formFields === null || formFields === void 0 ? void 0 : formFields.heartbeatIndices) || '',
  onChange: event => onChange({
    heartbeatIndices: event.currentTarget.value
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 75,
    columnNumber: 9
  }
}))));
exports.IndicesForm = IndicesForm;