"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsActions = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/kibana-react-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/settings/settings_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SettingsActions = ({
  isFormDisabled,
  isFormDirty,
  isFormValid,
  onApply,
  onCancel,
  errors
}) => {
  const {
    heartbeatIndices,
    invalidEmail,
    expirationThresholdError,
    ageThresholdError
  } = errors !== null && errors !== void 0 ? errors : {};
  const {
    to,
    cc,
    bcc
  } = invalidEmail !== null && invalidEmail !== void 0 ? invalidEmail : {};
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(WarningText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, heartbeatIndices || to || cc || bcc || expirationThresholdError || ageThresholdError)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "text",
    size: "s",
    iconType: "cross",
    "data-test-subj": "discardSettingsButton",
    isDisabled: !isFormDirty || isFormDisabled,
    onClick: () => {
      onCancel();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.discardSettingsButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    "data-test-subj": "apply-settings-button",
    onClick: onApply,
    color: "primary",
    isDisabled: !isFormDirty || !isFormValid || isFormDisabled,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.sourceConfiguration.applySettingsButtonLabel",
    defaultMessage: "Apply changes",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }))));
};
exports.SettingsActions = SettingsActions;
const WarningText = (0, _common.euiStyled)(_eui.EuiText)`
    box-shadow: -4px 0 ${props => props.theme.eui.euiColorWarning};
    padding-left: 8px;
`;