"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepDuration = void 0;
var _react = _interopRequireWildcard(require("react"));
var React = _react;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _step_field_trend = require("./step_field_trend");
var _formatting = require("../../../lib/formatting");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/check_steps/step_duration.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const StepDuration = ({
  step,
  durationPopoverOpenIndex,
  setDurationPopoverOpenIndex,
  showStepDurationTrend = true,
  compactView = false
}) => {
  var _step$synthetics$step2, _step$synthetics$step3, _step$synthetics$step6;
  const stepDurationText = (0, _react.useMemo)(() => {
    var _step$synthetics$step;
    return _i18n.i18n.translate('xpack.uptime.synthetics.step.duration', {
      defaultMessage: '{value} seconds',
      values: {
        value: (0, _formatting.microToSec)((_step$synthetics$step = step.synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.duration.us, 1)
      }
    });
  }, [(_step$synthetics$step2 = step.synthetics.step) === null || _step$synthetics$step2 === void 0 ? void 0 : _step$synthetics$step2.duration.us]);
  const component = (0, _react.useMemo)(() => /*#__PURE__*/React.createElement(_step_field_trend.StepFieldTrend, {
    step: step,
    field: 'synthetics.step.duration.us',
    title: STEP_DURATION_TREND,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), [step]);
  if (((_step$synthetics$step3 = step.synthetics.step) === null || _step$synthetics$step3 === void 0 ? void 0 : _step$synthetics$step3.status) === 'skipped') {
    return /*#__PURE__*/React.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 12
      }
    }, "--");
  }
  if (!showStepDurationTrend) {
    return /*#__PURE__*/React.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 12
      }
    }, stepDurationText);
  }
  const button = /*#__PURE__*/React.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "syntheticsStepDurationButton",
    onMouseEnter: () => {
      var _step$synthetics$step4, _step$synthetics$step5;
      return setDurationPopoverOpenIndex((_step$synthetics$step4 = (_step$synthetics$step5 = step.synthetics.step) === null || _step$synthetics$step5 === void 0 ? void 0 : _step$synthetics$step5.index) !== null && _step$synthetics$step4 !== void 0 ? _step$synthetics$step4 : null);
    },
    iconType: compactView ? undefined : 'visArea',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  }, stepDurationText);
  return /*#__PURE__*/React.createElement(_eui.EuiPopover, {
    onClick: evt => evt.stopPropagation(),
    isOpen: durationPopoverOpenIndex === ((_step$synthetics$step6 = step.synthetics.step) === null || _step$synthetics$step6 === void 0 ? void 0 : _step$synthetics$step6.index),
    button: button,
    closePopover: () => setDurationPopoverOpenIndex(null),
    zIndex: 100,
    ownFocus: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, component);
};
exports.StepDuration = StepDuration;
const STEP_DURATION_TREND = _i18n.i18n.translate('xpack.uptime.synthetics.step.durationTrend', {
  defaultMessage: 'Step duration trend'
});