"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExpandedStepCallback = getExpandedStepCallback;
exports.useExpandedRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _executed_step = require("../executed_step");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/check_steps/use_expanded_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getExpandedStepCallback(key) {
  return step => {
    var _step$synthetics, _step$synthetics$step;
    return ((_step$synthetics = step.synthetics) === null || _step$synthetics === void 0 ? void 0 : (_step$synthetics$step = _step$synthetics.step) === null || _step$synthetics$step === void 0 ? void 0 : _step$synthetics$step.index) === key;
  };
}
const useExpandedRow = ({
  loading,
  steps,
  allSteps
}) => {
  const [expandedRows, setExpandedRows] = (0, _react.useState)({});
  // eui table uses index from 0, synthetics uses 1

  const {
    checkGroupId
  } = (0, _reactRouterDom.useParams)();
  const getBrowserConsoles = (0, _react.useCallback)(index => {
    return allSteps.filter(stepF => {
      var _stepF$synthetics, _stepF$synthetics2, _stepF$synthetics2$st;
      return ((_stepF$synthetics = stepF.synthetics) === null || _stepF$synthetics === void 0 ? void 0 : _stepF$synthetics.type) === 'journey/browserconsole' && ((_stepF$synthetics2 = stepF.synthetics) === null || _stepF$synthetics2 === void 0 ? void 0 : (_stepF$synthetics2$st = _stepF$synthetics2.step) === null || _stepF$synthetics2$st === void 0 ? void 0 : _stepF$synthetics2$st.index) === index;
    }).map(stepF => {
      var _stepF$synthetics3, _stepF$synthetics3$pa;
      return (_stepF$synthetics3 = stepF.synthetics) === null || _stepF$synthetics3 === void 0 ? void 0 : (_stepF$synthetics3$pa = _stepF$synthetics3.payload) === null || _stepF$synthetics3$pa === void 0 ? void 0 : _stepF$synthetics3$pa.text;
    });
  }, [allSteps]);
  (0, _react.useEffect)(() => {
    const expandedRowsN = {};
    for (const expandedRowKey of Object.keys(expandedRows).map(key => Number(key))) {
      const step = steps.find(getExpandedStepCallback(expandedRowKey + 1));
      if (step) {
        var _step$synthetics2, _step$synthetics2$ste;
        expandedRowsN[expandedRowKey] = /*#__PURE__*/_react.default.createElement(_executed_step.ExecutedStep, {
          step: step,
          browserConsoles: getBrowserConsoles(expandedRowKey),
          index: (_step$synthetics2 = step.synthetics) === null || _step$synthetics2 === void 0 ? void 0 : (_step$synthetics2$ste = _step$synthetics2.step) === null || _step$synthetics2$ste === void 0 ? void 0 : _step$synthetics2$ste.index,
          loading: loading,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 51,
            columnNumber: 11
          }
        });
      }
    }
    setExpandedRows(expandedRowsN);

    // we only want to update when checkGroupId changes
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [checkGroupId, loading]);
  const toggleExpand = ({
    journeyStep
  }) => {
    var _journeyStep$syntheti, _journeyStep$syntheti2;
    // eui table uses index from 0, synthetics uses 1
    const stepIndex = ((_journeyStep$syntheti = journeyStep.synthetics) === null || _journeyStep$syntheti === void 0 ? void 0 : (_journeyStep$syntheti2 = _journeyStep$syntheti.step) === null || _journeyStep$syntheti2 === void 0 ? void 0 : _journeyStep$syntheti2.index) - 1;

    // If already expanded, collapse
    if (expandedRows[stepIndex]) {
      delete expandedRows[stepIndex];
      setExpandedRows({
        ...expandedRows
      });
    } else {
      var _journeyStep$syntheti3, _journeyStep$syntheti4;
      // Otherwise expand this row
      setExpandedRows({
        ...expandedRows,
        [stepIndex]: /*#__PURE__*/_react.default.createElement(_executed_step.ExecutedStep, {
          step: journeyStep,
          browserConsoles: getBrowserConsoles(stepIndex + 1),
          index: (_journeyStep$syntheti3 = journeyStep.synthetics) === null || _journeyStep$syntheti3 === void 0 ? void 0 : (_journeyStep$syntheti4 = _journeyStep$syntheti3.step) === null || _journeyStep$syntheti4 === void 0 ? void 0 : _journeyStep$syntheti4.index,
          loading: loading,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 11
          }
        })
      });
    }
  };
  return {
    expandedRows,
    toggleExpand
  };
};
exports.useExpandedRow = useExpandedRow;