"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepScreenshotDisplay = void 0;
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _useIntersection = _interopRequireDefault(require("react-use/lib/useIntersection"));
var _public = require("@kbn/observability-shared-plugin/public");
var _runtime_types = require("../../../../common/runtime_types");
var _contexts = require("../../contexts");
var _journey = require("../../state/api/journey");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1762430680480431322/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/uptime/public/legacy_uptime/components/synthetics/step_screenshot_display.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IMAGE_MAX_WIDTH = 640;
const StepImage = (0, _styledComponents.default)(_eui.EuiImage)`
  &&& {
    figcaption {
      display: none;
    }
    objectFit: 'cover',
    objectPosition: 'center top',
  }
`;
const BaseStepImage = ({
  stepIndex,
  stepName,
  url
}) => {
  if (!url) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 20
    }
  });
  return /*#__PURE__*/_react.default.createElement(StepImage, {
    allowFullScreen: true,
    alt: stepName ? _i18n.i18n.translate('xpack.uptime.synthetics.screenshotDisplay.altText', {
      defaultMessage: 'Screenshot for step with name "{stepName}"',
      values: {
        stepName
      }
    }) : _i18n.i18n.translate('xpack.uptime.synthetics.screenshotDisplay.altTextWithoutName', {
      defaultMessage: 'Screenshot'
    }),
    caption: `Step:${stepIndex} ${stepName}`,
    hasShadow: true,
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  });
};
const ComposedStepImage = ({
  stepIndex,
  stepName,
  url,
  imgRef,
  setUrl
}) => {
  (0, _hooks.useCompositeImage)(imgRef, setUrl, url);
  if (!url) return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 20
    }
  });
  return /*#__PURE__*/_react.default.createElement(BaseStepImage, {
    stepIndex: stepIndex,
    stepName: stepName,
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 10
    }
  });
};
const StepScreenshotDisplay = ({
  checkGroup,
  isFullScreenshot: isScreenshotBlob,
  isScreenshotRef,
  stepIndex,
  stepName,
  lazyLoad = true
}) => {
  var _refDimensions$width, _refDimensions$height;
  const containerRef = (0, _react.useRef)(null);
  const theme = (0, _eui.useEuiTheme)();
  const pageBackground = theme.euiTheme.colors.lightestShade;
  const {
    basePath
  } = (0, _react.useContext)(_contexts.UptimeSettingsContext);
  const intersection = (0, _useIntersection.default)(containerRef, {
    root: null,
    rootMargin: '0px',
    threshold: 1
  });
  const {
    lastRefresh
  } = (0, _react.useContext)(_contexts.UptimeRefreshContext);
  const [hasIntersected, setHasIntersected] = (0, _react.useState)(false);
  const isIntersecting = intersection === null || intersection === void 0 ? void 0 : intersection.isIntersecting;
  (0, _react.useEffect)(() => {
    if (hasIntersected === false && isIntersecting === true) {
      setHasIntersected(true);
    }
  }, [hasIntersected, isIntersecting, setHasIntersected]);
  const imgSrc = basePath + `/internal/uptime/journey/screenshot/${checkGroup}/${stepIndex}`;

  // When loading a legacy screenshot, set `url` to full-size screenshot path.
  // Otherwise, we first need to composite the image.
  const [url, setUrl] = (0, _react.useState)(isScreenshotBlob ? imgSrc : undefined);

  // when the image is a composite, we need to fetch the data since we cannot specify a blob URL
  const {
    data: screenshotRef
  } = (0, _public.useFetcher)(() => {
    if (isScreenshotRef) {
      return (0, _journey.getJourneyScreenshot)(imgSrc);
    }
    // FIXME: Dario thinks there is a better way to do this but
    // he's getting tired and maybe the Uptime folks can fix it
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [basePath, checkGroup, imgSrc, stepIndex, isScreenshotRef, lastRefresh]);
  const refDimensions = (0, _react.useMemo)(() => {
    if ((0, _runtime_types.isScreenshotRef)(screenshotRef)) {
      const {
        height,
        width
      } = screenshotRef.ref.screenshotRef.screenshot_ref;
      return {
        height,
        width
      };
    }
  }, [screenshotRef]);
  const shouldRenderImage = hasIntersected || !lazyLoad;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: containerRef,
    style: {
      backgroundColor: pageBackground,
      maxWidth: Math.min(IMAGE_MAX_WIDTH, (_refDimensions$width = refDimensions === null || refDimensions === void 0 ? void 0 : refDimensions.width) !== null && _refDimensions$width !== void 0 ? _refDimensions$width : Number.MAX_VALUE),
      maxHeight: (_refDimensions$height = refDimensions === null || refDimensions === void 0 ? void 0 : refDimensions.height) !== null && _refDimensions$height !== void 0 ? _refDimensions$height : undefined
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 5
    }
  }, shouldRenderImage && isScreenshotBlob && /*#__PURE__*/_react.default.createElement(BaseStepImage, {
    stepName: stepName,
    stepIndex: stepIndex,
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }), shouldRenderImage && isScreenshotRef && (0, _runtime_types.isScreenshotRef)(screenshotRef) && /*#__PURE__*/_react.default.createElement(ComposedStepImage, {
    imgRef: screenshotRef,
    stepName: stepName,
    stepIndex: stepIndex,
    setUrl: setUrl,
    url: url,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), !isScreenshotBlob && !isScreenshotRef && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "column",
    style: {
      paddingTop: '32px'
    },
    "data-test-subj": "stepScreenshotImageUnavailable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    color: "subdued",
    size: "xxl",
    type: "image",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.uptime.synthetics.screenshot.noImageMessage",
    defaultMessage: "No image available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }))))));
};
exports.StepScreenshotDisplay = StepScreenshotDisplay;